/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.job;

import io.zeebe.engine.processor.CommandProcessor;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.state.instance.JobState;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.JobIntent;

public class CompleteProcessor
implements CommandProcessor<JobRecord> {
    public static final String NO_JOB_FOUND_MESSAGE = "Expected to complete job with key '%d', but no such job was found";
    public static final String FAILED_JOB_MESSAGE = "Expected to complete job with key '%d', but the job is marked as failed";
    private final JobState state;

    public CompleteProcessor(JobState state) {
        this.state = state;
    }

    @Override
    public void onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        long jobKey = command.getKey();
        JobState.State jobState = this.state.getState(jobKey);
        if (jobState == JobState.State.NOT_FOUND) {
            commandControl.reject(RejectionType.NOT_FOUND, String.format(NO_JOB_FOUND_MESSAGE, jobKey));
        } else if (jobState == JobState.State.FAILED) {
            commandControl.reject(RejectionType.INVALID_STATE, String.format(FAILED_JOB_MESSAGE, jobKey));
        } else {
            JobRecord job = this.state.getJob(jobKey);
            job.setVariables(command.getValue().getVariablesBuffer());
            this.state.delete(jobKey, job);
            commandControl.accept((Intent)JobIntent.COMPLETED, job);
        }
    }
}

