/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.job;

import io.zeebe.engine.processor.CommandProcessor;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.state.instance.JobState;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.JobIntent;

public class FailProcessor
implements CommandProcessor<JobRecord> {
    public static final String NOT_ACTIVATED_JOB_MESSAGE = "Expected to fail activated job with key '%d', but it %s";
    private final JobState state;

    public FailProcessor(JobState state) {
        this.state = state;
    }

    @Override
    public void onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        long key = command.getKey();
        JobState.State jobState = this.state.getState(key);
        if (jobState == JobState.State.ACTIVATED) {
            JobRecord failedJob = this.state.getJob(key);
            failedJob.setRetries(command.getValue().getRetries());
            failedJob.setErrorMessage(command.getValue().getErrorMessageBuffer());
            this.state.fail(key, failedJob);
            commandControl.accept((Intent)JobIntent.FAILED, failedJob);
        } else if (jobState == JobState.State.ACTIVATABLE) {
            commandControl.reject(RejectionType.INVALID_STATE, String.format(NOT_ACTIVATED_JOB_MESSAGE, key, "must be activated first"));
        } else if (jobState == JobState.State.FAILED) {
            commandControl.reject(RejectionType.INVALID_STATE, String.format(NOT_ACTIVATED_JOB_MESSAGE, key, "is marked as failed"));
        } else {
            commandControl.reject(RejectionType.NOT_FOUND, String.format(NOT_ACTIVATED_JOB_MESSAGE, key, "does not exist"));
        }
    }
}

