/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.job;

import io.zeebe.engine.processor.KeyGenerator;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.state.instance.JobState;
import io.zeebe.engine.state.instance.VariablesState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.msgpack.value.DocumentValue;
import io.zeebe.msgpack.value.LongValue;
import io.zeebe.msgpack.value.ValueArray;
import io.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.JobBatchIntent;
import io.zeebe.protocol.record.intent.JobIntent;
import io.zeebe.util.sched.clock.ActorClock;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ObjectHashSet;
import org.agrona.concurrent.UnsafeBuffer;

public class JobBatchActivateProcessor
implements TypedRecordProcessor<JobBatchRecord> {
    private final JobState jobState;
    private final VariablesState variablesState;
    private final KeyGenerator keyGenerator;
    private final ObjectHashSet<DirectBuffer> variableNames = new ObjectHashSet();

    public JobBatchActivateProcessor(JobState jobState, VariablesState variablesState, KeyGenerator keyGenerator) {
        this.jobState = jobState;
        this.variablesState = variablesState;
        this.keyGenerator = keyGenerator;
    }

    @Override
    public void processRecord(TypedRecord<JobBatchRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        JobBatchRecord value = record.getValue();
        if (this.isValid(value)) {
            this.activateJobs(record, responseWriter, streamWriter);
        } else {
            this.rejectCommand(record, responseWriter, streamWriter);
        }
    }

    private boolean isValid(JobBatchRecord record) {
        return record.getMaxJobsToActivate() > 0 && record.getTimeoutLong() > 0L && record.getTypeBuffer().capacity() > 0 && record.getWorkerBuffer().capacity() > 0;
    }

    private void activateJobs(TypedRecord<JobBatchRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        JobBatchRecord value = record.getValue();
        long jobBatchKey = this.keyGenerator.nextKey();
        AtomicInteger amount = new AtomicInteger(value.getMaxJobsToActivate());
        this.collectJobsToActivate(record, amount);
        this.activateJobs(streamWriter, value);
        streamWriter.appendFollowUpEvent(jobBatchKey, (Intent)JobBatchIntent.ACTIVATED, (UnpackedObject)value);
        responseWriter.writeEventOnCommand(jobBatchKey, (Intent)JobBatchIntent.ACTIVATED, (UnpackedObject)value, record);
    }

    private void collectJobsToActivate(TypedRecord<JobBatchRecord> record, AtomicInteger amount) {
        JobBatchRecord value = record.getValue();
        ValueArray jobIterator = value.jobs();
        ValueArray jobKeyIterator = value.jobKeys();
        this.variableNames.clear();
        ValueArray jobBatchVariables = value.variables();
        jobBatchVariables.forEach(v -> {
            UnsafeBuffer nameCopy = new UnsafeBuffer(new byte[v.getValue().capacity()]);
            nameCopy.putBytes(0, v.getValue(), 0, v.getValue().capacity());
            this.variableNames.add((Object)nameCopy);
        });
        this.jobState.forEachActivatableJobs(value.getTypeBuffer(), (key, jobRecord) -> {
            int remainingAmount = amount.get();
            long deadline = ActorClock.currentTimeMillis() + value.getTimeoutLong();
            jobRecord.setDeadline(deadline).setWorker(value.getWorkerBuffer());
            long elementInstanceKey = jobRecord.getJobHeaders().getElementInstanceKey();
            if (elementInstanceKey >= 0L) {
                DirectBuffer variables = this.collectVariables((Collection<DirectBuffer>)this.variableNames, elementInstanceKey);
                jobRecord.setVariables(variables);
            } else {
                jobRecord.setVariables(DocumentValue.EMPTY_DOCUMENT);
            }
            if (remainingAmount < 0 || value.getLength() + 8 + jobRecord.getLength() > record.getMaxValueLength()) {
                value.setTruncated(true);
                return false;
            }
            remainingAmount = amount.decrementAndGet();
            ((LongValue)jobKeyIterator.add()).setValue(key.longValue());
            JobRecord arrayValueJob = (JobRecord)jobIterator.add();
            ExpandableArrayBuffer buffer = new ExpandableArrayBuffer(jobRecord.getLength());
            jobRecord.write((MutableDirectBuffer)buffer, 0);
            arrayValueJob.wrap((DirectBuffer)buffer);
            return remainingAmount > 0;
        });
    }

    private void activateJobs(TypedStreamWriter streamWriter, JobBatchRecord value) {
        Iterator iterator = value.jobs().iterator();
        Iterator keyIt = value.jobKeys().iterator();
        while (iterator.hasNext() && keyIt.hasNext()) {
            JobRecord jobRecord = (JobRecord)iterator.next();
            LongValue next1 = (LongValue)keyIt.next();
            long key = next1.getValue();
            ExpandableArrayBuffer copy = new ExpandableArrayBuffer();
            jobRecord.write((MutableDirectBuffer)copy, 0);
            JobRecord copiedJob = new JobRecord();
            copiedJob.wrap((DirectBuffer)copy, 0, jobRecord.getLength());
            streamWriter.appendFollowUpEvent(key, (Intent)JobIntent.ACTIVATED, (UnpackedObject)copiedJob);
            this.jobState.activate(key, copiedJob);
        }
    }

    private DirectBuffer collectVariables(Collection<DirectBuffer> variableNames, long elementInstanceKey) {
        DirectBuffer variables = variableNames.isEmpty() ? this.variablesState.getVariablesAsDocument(elementInstanceKey) : this.variablesState.getVariablesAsDocument(elementInstanceKey, variableNames);
        return variables;
    }

    private void rejectCommand(TypedRecord<JobBatchRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        String rejectionReason;
        RejectionType rejectionType;
        JobBatchRecord value = record.getValue();
        String format = "Expected to activate job batch with %s to be %s, but it was %s";
        if (value.getMaxJobsToActivate() < 1) {
            rejectionType = RejectionType.INVALID_ARGUMENT;
            rejectionReason = String.format("Expected to activate job batch with %s to be %s, but it was %s", "max jobs to activate", "greater than zero", String.format("'%d'", value.getMaxJobsToActivate()));
        } else if (value.getTimeoutLong() < 1L) {
            rejectionType = RejectionType.INVALID_ARGUMENT;
            rejectionReason = String.format("Expected to activate job batch with %s to be %s, but it was %s", "timeout", "greater than zero", String.format("'%d'", value.getTimeoutLong()));
        } else if (value.getTypeBuffer().capacity() < 1) {
            rejectionType = RejectionType.INVALID_ARGUMENT;
            rejectionReason = String.format("Expected to activate job batch with %s to be %s, but it was %s", "type", "present", "blank");
        } else if (value.getWorkerBuffer().capacity() < 1) {
            rejectionType = RejectionType.INVALID_ARGUMENT;
            rejectionReason = String.format("Expected to activate job batch with %s to be %s, but it was %s", "worker", "present", "blank");
        } else {
            throw new IllegalStateException("Expected to reject an invalid activate job batch command, but it appears to be valid");
        }
        streamWriter.appendRejection(record, rejectionType, rejectionReason);
        responseWriter.writeRejectionOnCommand(record, rejectionType, rejectionReason);
    }
}

