/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.job;

import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.job.JobHeaders;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;

public final class JobCompletedEventProcessor
implements TypedRecordProcessor<JobRecord> {
    private final WorkflowState workflowState;

    public JobCompletedEventProcessor(WorkflowState workflowState) {
        this.workflowState = workflowState;
    }

    @Override
    public void processRecord(TypedRecord<JobRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        JobRecord jobEvent = record.getValue();
        JobHeaders jobHeaders = jobEvent.getJobHeaders();
        long elementInstanceKey = jobHeaders.getElementInstanceKey();
        ElementInstance elementInstance = this.workflowState.getElementInstanceState().getInstance(elementInstanceKey);
        if (elementInstance != null) {
            long scopeKey = elementInstance.getValue().getFlowScopeKey();
            ElementInstance scopeInstance = this.workflowState.getElementInstanceState().getInstance(scopeKey);
            if (scopeInstance.isActive()) {
                WorkflowInstanceRecord value = elementInstance.getValue();
                streamWriter.appendFollowUpEvent(elementInstanceKey, (Intent)WorkflowInstanceIntent.ELEMENT_COMPLETING, (UnpackedObject)value);
                elementInstance.setState(WorkflowInstanceIntent.ELEMENT_COMPLETING);
                elementInstance.setJobKey(-1L);
                elementInstance.setValue(value);
                this.workflowState.getElementInstanceState().updateInstance(elementInstance);
                this.workflowState.getEventScopeInstanceState().shutdownInstance(elementInstanceKey);
                this.workflowState.getElementInstanceState().getVariablesState().setTemporaryVariables(elementInstanceKey, jobEvent.getVariablesBuffer());
            }
        }
    }
}

