/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.job;

import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.instance.ElementInstanceState;
import io.zeebe.protocol.impl.record.value.job.JobHeaders;
import io.zeebe.protocol.impl.record.value.job.JobRecord;

public final class JobCreatedProcessor
implements TypedRecordProcessor<JobRecord> {
    private final WorkflowState workflowState;

    public JobCreatedProcessor(WorkflowState scopeInstances) {
        this.workflowState = scopeInstances;
    }

    @Override
    public void processRecord(TypedRecord<JobRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        ElementInstanceState elementInstanceState;
        ElementInstance elementInstance;
        JobHeaders jobHeaders = record.getValue().getJobHeaders();
        long elementInstanceKey = jobHeaders.getElementInstanceKey();
        if (elementInstanceKey > 0L && (elementInstance = (elementInstanceState = this.workflowState.getElementInstanceState()).getInstance(elementInstanceKey)) != null) {
            elementInstance.setJobKey(record.getKey());
            elementInstanceState.updateInstance(elementInstance);
        }
    }
}

