/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.job;

import io.zeebe.engine.processor.TypedRecordProcessors;
import io.zeebe.engine.processor.workflow.job.CancelProcessor;
import io.zeebe.engine.processor.workflow.job.CompleteProcessor;
import io.zeebe.engine.processor.workflow.job.CreateProcessor;
import io.zeebe.engine.processor.workflow.job.FailProcessor;
import io.zeebe.engine.processor.workflow.job.JobBatchActivateProcessor;
import io.zeebe.engine.processor.workflow.job.JobCompletedEventProcessor;
import io.zeebe.engine.processor.workflow.job.JobCreatedProcessor;
import io.zeebe.engine.processor.workflow.job.JobFailedProcessor;
import io.zeebe.engine.processor.workflow.job.JobTimeoutTrigger;
import io.zeebe.engine.processor.workflow.job.TimeOutProcessor;
import io.zeebe.engine.processor.workflow.job.UpdateRetriesProcessor;
import io.zeebe.engine.state.ZeebeState;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.engine.state.instance.JobState;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.JobBatchIntent;
import io.zeebe.protocol.record.intent.JobIntent;

public class JobEventProcessors {
    public static void addJobProcessors(TypedRecordProcessors typedRecordProcessors, ZeebeState zeebeState) {
        WorkflowState workflowState = zeebeState.getWorkflowState();
        JobState jobState = zeebeState.getJobState();
        typedRecordProcessors.onEvent(ValueType.JOB, (Intent)JobIntent.CREATED, new JobCreatedProcessor(workflowState)).onEvent(ValueType.JOB, (Intent)JobIntent.COMPLETED, new JobCompletedEventProcessor(workflowState)).onCommand(ValueType.JOB, (Intent)JobIntent.CREATE, new CreateProcessor(jobState)).onCommand(ValueType.JOB, (Intent)JobIntent.COMPLETE, new CompleteProcessor(jobState)).onCommand(ValueType.JOB, (Intent)JobIntent.FAIL, new FailProcessor(jobState)).onEvent(ValueType.JOB, (Intent)JobIntent.FAILED, new JobFailedProcessor()).onCommand(ValueType.JOB, (Intent)JobIntent.TIME_OUT, new TimeOutProcessor(jobState)).onCommand(ValueType.JOB, (Intent)JobIntent.UPDATE_RETRIES, new UpdateRetriesProcessor(jobState)).onCommand(ValueType.JOB, (Intent)JobIntent.CANCEL, new CancelProcessor(jobState)).onCommand(ValueType.JOB_BATCH, (Intent)JobBatchIntent.ACTIVATE, new JobBatchActivateProcessor(jobState, workflowState.getElementInstanceState().getVariablesState(), zeebeState.getKeyGenerator())).withListener(new JobTimeoutTrigger(jobState));
    }
}

