/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.job;

import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.zeebe.protocol.impl.record.value.job.JobHeaders;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.record.intent.IncidentIntent;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.value.ErrorType;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class JobFailedProcessor
implements TypedRecordProcessor<JobRecord> {
    private static final DirectBuffer DEFAULT_ERROR_MESSAGE = BufferUtil.wrapString((String)"No more retries left.");
    private final IncidentRecord incidentEvent = new IncidentRecord();

    @Override
    public void processRecord(TypedRecord<JobRecord> event, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        JobRecord value = event.getValue();
        if (value.getRetries() <= 0) {
            JobHeaders jobHeaders = value.getJobHeaders();
            DirectBuffer jobErrorMessage = value.getErrorMessageBuffer();
            DirectBuffer incidentErrorMessage = DEFAULT_ERROR_MESSAGE;
            if (jobErrorMessage.capacity() > 0) {
                incidentErrorMessage = jobErrorMessage;
            }
            this.incidentEvent.reset();
            this.incidentEvent.setErrorType(ErrorType.JOB_NO_RETRIES).setErrorMessage(incidentErrorMessage).setBpmnProcessId(jobHeaders.getBpmnProcessIdBuffer()).setWorkflowKey(jobHeaders.getWorkflowKey()).setWorkflowInstanceKey(jobHeaders.getWorkflowInstanceKey()).setElementId(jobHeaders.getElementIdBuffer()).setElementInstanceKey(jobHeaders.getElementInstanceKey()).setJobKey(event.getKey()).setVariableScopeKey(jobHeaders.getElementInstanceKey());
            streamWriter.appendNewCommand((Intent)IncidentIntent.CREATE, (UnpackedObject)this.incidentEvent);
        }
    }
}

