/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.job;

import io.zeebe.engine.processor.ReadonlyProcessingContext;
import io.zeebe.engine.processor.StreamProcessorLifecycleAware;
import io.zeebe.engine.processor.TypedCommandWriter;
import io.zeebe.engine.state.instance.JobState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.JobIntent;
import io.zeebe.util.sched.ScheduledTimer;
import io.zeebe.util.sched.clock.ActorClock;
import java.time.Duration;

public class JobTimeoutTrigger
implements StreamProcessorLifecycleAware {
    public static final Duration TIME_OUT_POLLING_INTERVAL = Duration.ofSeconds(30L);
    private final JobState state;
    private ScheduledTimer timer;
    private TypedCommandWriter writer;

    public JobTimeoutTrigger(JobState state) {
        this.state = state;
    }

    @Override
    public void onRecovered(ReadonlyProcessingContext processingContext) {
        this.timer = processingContext.getActor().runAtFixedRate(TIME_OUT_POLLING_INTERVAL, this::deactivateTimedOutJobs);
        this.writer = processingContext.getLogStreamWriter();
    }

    @Override
    public void onClose() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    void deactivateTimedOutJobs() {
        long now = ActorClock.currentTimeMillis();
        this.state.forEachTimedOutEntry(now, (key, record) -> {
            boolean flushed;
            this.writer.appendFollowUpCommand((long)key, (Intent)JobIntent.TIME_OUT, (UnpackedObject)record, m -> m.valueType(ValueType.JOB));
            boolean bl = flushed = this.writer.flush() >= 0L;
            if (!flushed) {
                this.writer.reset();
            }
            return flushed;
        });
    }
}

