/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.job;

import io.zeebe.engine.processor.CommandProcessor;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.state.instance.JobState;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.JobIntent;

public class TimeOutProcessor
implements CommandProcessor<JobRecord> {
    public static final String NOT_ACTIVATED_JOB_MESSAGE = "Expected to time out activated job with key '%d', but %s";
    private final JobState state;

    public TimeOutProcessor(JobState state) {
        this.state = state;
    }

    @Override
    public void onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        long jobKey = command.getKey();
        JobState.State jobState = this.state.getState(jobKey);
        if (jobState == JobState.State.ACTIVATED) {
            this.state.timeout(command.getKey(), command.getValue());
            commandControl.accept((Intent)JobIntent.TIMED_OUT, command.getValue());
        } else {
            String textState;
            switch (jobState) {
                case ACTIVATABLE: {
                    textState = "it must be activated first";
                    break;
                }
                case FAILED: {
                    textState = "it is marked as failed";
                    break;
                }
                default: {
                    textState = "no such job was found";
                }
            }
            commandControl.reject(RejectionType.NOT_FOUND, String.format(NOT_ACTIVATED_JOB_MESSAGE, jobKey, textState));
        }
    }
}

