/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.job;

import io.zeebe.engine.processor.CommandProcessor;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.state.instance.JobState;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.JobIntent;

public class UpdateRetriesProcessor
implements CommandProcessor<JobRecord> {
    private static final String NO_JOB_FOUND_MESSAGE = "Expected to update retries for job with key '%d', but no such job was found";
    private static final String NEGATIVE_RETRIES_MESSAGE = "Expected to update retries for job with key '%d' with a positive amount of retries, but the amount given was '%d'";
    private final JobState state;

    public UpdateRetriesProcessor(JobState state) {
        this.state = state;
    }

    @Override
    public void onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        long key = command.getKey();
        int retries = command.getValue().getRetries();
        if (retries > 0) {
            JobRecord updatedJob = this.state.updateJobRetries(key, retries);
            if (updatedJob != null) {
                commandControl.accept((Intent)JobIntent.RETRIES_UPDATED, updatedJob);
            } else {
                commandControl.reject(RejectionType.NOT_FOUND, String.format(NO_JOB_FOUND_MESSAGE, key));
            }
        } else {
            commandControl.reject(RejectionType.INVALID_ARGUMENT, String.format(NEGATIVE_RETRIES_MESSAGE, key, retries));
        }
    }
}

