/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message;

import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.state.message.MessageStartEventSubscriptionState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;

public class CloseMessageStartEventSubscriptionProcessor
implements TypedRecordProcessor<MessageStartEventSubscriptionRecord> {
    private final MessageStartEventSubscriptionState subscriptionState;

    public CloseMessageStartEventSubscriptionProcessor(MessageStartEventSubscriptionState subscriptionState) {
        this.subscriptionState = subscriptionState;
    }

    @Override
    public void processRecord(TypedRecord<MessageStartEventSubscriptionRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        MessageStartEventSubscriptionRecord subscriptionRecord = record.getValue();
        long workflowKey = subscriptionRecord.getWorkflowKey();
        this.subscriptionState.removeSubscriptionsOfWorkflow(workflowKey);
        streamWriter.appendFollowUpEvent(record.getKey(), (Intent)MessageStartEventSubscriptionIntent.CLOSED, (UnpackedObject)subscriptionRecord);
    }
}

