/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message;

import io.zeebe.engine.processor.SideEffectProducer;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.processor.workflow.message.command.SubscriptionCommandSender;
import io.zeebe.engine.state.message.MessageSubscriptionState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.zeebe.util.buffer.BufferUtil;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;

public class CloseMessageSubscriptionProcessor
implements TypedRecordProcessor<MessageSubscriptionRecord> {
    public static final String NO_SUBSCRIPTION_FOUND_MESSAGE = "Expected to close message subscription for element with key '%d' and message name '%s', but no such message subscription exists";
    private final MessageSubscriptionState subscriptionState;
    private final SubscriptionCommandSender commandSender;
    private MessageSubscriptionRecord subscriptionRecord;

    public CloseMessageSubscriptionProcessor(MessageSubscriptionState subscriptionState, SubscriptionCommandSender commandSender) {
        this.subscriptionState = subscriptionState;
        this.commandSender = commandSender;
    }

    @Override
    public void processRecord(TypedRecord<MessageSubscriptionRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        this.subscriptionRecord = record.getValue();
        boolean removed = this.subscriptionState.remove(this.subscriptionRecord.getElementInstanceKey(), this.subscriptionRecord.getMessageNameBuffer());
        if (removed) {
            streamWriter.appendFollowUpEvent(record.getKey(), (Intent)MessageSubscriptionIntent.CLOSED, (UnpackedObject)this.subscriptionRecord);
        } else {
            streamWriter.appendRejection(record, RejectionType.NOT_FOUND, String.format(NO_SUBSCRIPTION_FOUND_MESSAGE, this.subscriptionRecord.getElementInstanceKey(), BufferUtil.bufferAsString((DirectBuffer)this.subscriptionRecord.getMessageNameBuffer())));
        }
        sideEffect.accept(this::sendAcknowledgeCommand);
    }

    private boolean sendAcknowledgeCommand() {
        return this.commandSender.closeWorkflowInstanceSubscription(this.subscriptionRecord.getWorkflowInstanceKey(), this.subscriptionRecord.getElementInstanceKey(), this.subscriptionRecord.getMessageNameBuffer());
    }
}

