/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message;

import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.state.message.WorkflowInstanceSubscriptionState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.message.WorkflowInstanceSubscriptionRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.WorkflowInstanceSubscriptionIntent;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class CloseWorkflowInstanceSubscription
implements TypedRecordProcessor<WorkflowInstanceSubscriptionRecord> {
    public static final String NO_SUBSCRIPTION_FOUND_MESSAGE = "Expected to close workflow instance subscription for element with key '%d' and message name '%s', but no such subscription was found";
    private final WorkflowInstanceSubscriptionState subscriptionState;

    public CloseWorkflowInstanceSubscription(WorkflowInstanceSubscriptionState subscriptionState) {
        this.subscriptionState = subscriptionState;
    }

    @Override
    public void processRecord(TypedRecord<WorkflowInstanceSubscriptionRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        WorkflowInstanceSubscriptionRecord subscription = record.getValue();
        boolean removed = this.subscriptionState.remove(subscription.getElementInstanceKey(), subscription.getMessageNameBuffer());
        if (removed) {
            streamWriter.appendFollowUpEvent(record.getKey(), (Intent)WorkflowInstanceSubscriptionIntent.CLOSED, (UnpackedObject)subscription);
        } else {
            streamWriter.appendRejection(record, RejectionType.NOT_FOUND, String.format(NO_SUBSCRIPTION_FOUND_MESSAGE, subscription.getElementInstanceKey(), BufferUtil.bufferAsString((DirectBuffer)subscription.getMessageNameBuffer())));
        }
    }
}

