/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message;

import io.zeebe.engine.processor.SideEffectProducer;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.processor.workflow.message.MessageCorrelator;
import io.zeebe.engine.processor.workflow.message.command.SubscriptionCommandSender;
import io.zeebe.engine.state.message.MessageState;
import io.zeebe.engine.state.message.MessageSubscription;
import io.zeebe.engine.state.message.MessageSubscriptionState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.zeebe.util.buffer.BufferUtil;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;

public class CorrelateMessageSubscriptionProcessor
implements TypedRecordProcessor<MessageSubscriptionRecord> {
    public static final String NO_SUBSCRIPTION_FOUND_MESSAGE = "Expected to correlate subscription for element with key '%d' and message name '%s', but no such message subscription exists";
    private final MessageSubscriptionState subscriptionState;
    private final MessageCorrelator messageCorrelator;

    public CorrelateMessageSubscriptionProcessor(MessageState messageState, MessageSubscriptionState subscriptionState, SubscriptionCommandSender commandSender) {
        this.subscriptionState = subscriptionState;
        this.messageCorrelator = new MessageCorrelator(messageState, subscriptionState, commandSender);
    }

    @Override
    public void processRecord(TypedRecord<MessageSubscriptionRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        MessageSubscriptionRecord subscriptionRecord = record.getValue();
        MessageSubscription subscription = this.subscriptionState.get(subscriptionRecord.getElementInstanceKey(), subscriptionRecord.getMessageNameBuffer());
        if (subscription != null) {
            if (subscription.shouldCloseOnCorrelate()) {
                this.subscriptionState.remove(subscription);
            } else {
                this.subscriptionState.resetSentTime(subscription);
                this.messageCorrelator.correlateNextMessage(subscription, subscriptionRecord, sideEffect);
            }
            streamWriter.appendFollowUpEvent(record.getKey(), (Intent)MessageSubscriptionIntent.CORRELATED, (UnpackedObject)subscriptionRecord);
        } else {
            streamWriter.appendRejection(record, RejectionType.NOT_FOUND, String.format(NO_SUBSCRIPTION_FOUND_MESSAGE, subscriptionRecord.getElementInstanceKey(), BufferUtil.bufferAsString((DirectBuffer)subscriptionRecord.getMessageNameBuffer())));
        }
    }
}

