/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message;

import io.zeebe.engine.processor.KeyGenerator;
import io.zeebe.engine.processor.ReadonlyProcessingContext;
import io.zeebe.engine.processor.SideEffectProducer;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.processor.workflow.message.PendingWorkflowInstanceSubscriptionChecker;
import io.zeebe.engine.processor.workflow.message.command.SubscriptionCommandSender;
import io.zeebe.engine.state.ZeebeState;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.message.WorkflowInstanceSubscription;
import io.zeebe.engine.state.message.WorkflowInstanceSubscriptionState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.message.WorkflowInstanceSubscriptionRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.protocol.record.intent.WorkflowInstanceSubscriptionIntent;
import io.zeebe.util.buffer.BufferUtil;
import io.zeebe.util.sched.ActorControl;
import java.time.Duration;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;

public final class CorrelateWorkflowInstanceSubscription
implements TypedRecordProcessor<WorkflowInstanceSubscriptionRecord> {
    private static final Duration SUBSCRIPTION_TIMEOUT = Duration.ofSeconds(10L);
    private static final Duration SUBSCRIPTION_CHECK_INTERVAL = Duration.ofSeconds(30L);
    private static final String NO_EVENT_OCCURRED_MESSAGE = "Expected to correlate a workflow instance subscription with element key '%d' and message name '%s', but the subscription is not active anymore";
    private static final String NO_SUBSCRIPTION_FOUND_MESSAGE = "Expected to correlate workflow instance subscription with element key '%d' and message name '%s', but no such subscription was found";
    private static final String ALREADY_CLOSING_MESSAGE = "Expected to correlate workflow instance subscription with element key '%d' and message name '%s', but it is already closing";
    private final WorkflowInstanceSubscriptionState subscriptionState;
    private final SubscriptionCommandSender subscriptionCommandSender;
    private final WorkflowState workflowState;
    private final KeyGenerator keyGenerator;
    private WorkflowInstanceSubscriptionRecord subscriptionRecord;
    private DirectBuffer correlationKey;

    public CorrelateWorkflowInstanceSubscription(WorkflowInstanceSubscriptionState subscriptionState, SubscriptionCommandSender subscriptionCommandSender, ZeebeState zeebeState) {
        this.subscriptionState = subscriptionState;
        this.subscriptionCommandSender = subscriptionCommandSender;
        this.workflowState = zeebeState.getWorkflowState();
        this.keyGenerator = zeebeState.getKeyGenerator();
    }

    @Override
    public void onOpen(ReadonlyProcessingContext processingContext) {
        ActorControl actor = processingContext.getActor();
        PendingWorkflowInstanceSubscriptionChecker pendingSubscriptionChecker = new PendingWorkflowInstanceSubscriptionChecker(this.subscriptionCommandSender, this.subscriptionState, SUBSCRIPTION_TIMEOUT.toMillis());
        actor.runAtFixedRate(SUBSCRIPTION_CHECK_INTERVAL, (Runnable)pendingSubscriptionChecker);
    }

    @Override
    public void onClose() {
    }

    @Override
    public void processRecord(TypedRecord<WorkflowInstanceSubscriptionRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        this.subscriptionRecord = record.getValue();
        long elementInstanceKey = this.subscriptionRecord.getElementInstanceKey();
        WorkflowInstanceSubscription subscription = this.subscriptionState.getSubscription(elementInstanceKey, this.subscriptionRecord.getMessageNameBuffer());
        if (subscription == null || subscription.isClosing()) {
            RejectionType type = RejectionType.NOT_FOUND;
            String reason = NO_SUBSCRIPTION_FOUND_MESSAGE;
            if (subscription != null) {
                type = RejectionType.INVALID_STATE;
                reason = ALREADY_CLOSING_MESSAGE;
                this.correlationKey = subscription.getCorrelationKey();
            } else {
                this.correlationKey = null;
            }
            sideEffect.accept(this::sendRejectionCommand);
            streamWriter.appendRejection(record, type, String.format(reason, this.subscriptionRecord.getElementInstanceKey(), BufferUtil.bufferAsString((DirectBuffer)this.subscriptionRecord.getMessageNameBuffer())));
            return;
        }
        if (subscription.shouldCloseOnCorrelate()) {
            this.subscriptionState.remove(subscription);
        }
        ElementInstance elementInstance = this.workflowState.getElementInstanceState().getInstance(subscription.getElementInstanceKey());
        long eventKey = this.keyGenerator.nextKey();
        boolean isOccurred = this.workflowState.getEventScopeInstanceState().triggerEvent(this.subscriptionRecord.getElementInstanceKey(), eventKey, subscription.getHandlerNodeId(), record.getValue().getVariablesBuffer());
        if (isOccurred) {
            sideEffect.accept(this::sendAcknowledgeCommand);
            streamWriter.appendFollowUpEvent(record.getKey(), (Intent)WorkflowInstanceSubscriptionIntent.CORRELATED, (UnpackedObject)this.subscriptionRecord);
            streamWriter.appendFollowUpEvent(this.subscriptionRecord.getElementInstanceKey(), (Intent)WorkflowInstanceIntent.EVENT_OCCURRED, (UnpackedObject)elementInstance.getValue());
        } else {
            this.correlationKey = subscription.getCorrelationKey();
            sideEffect.accept(this::sendRejectionCommand);
            streamWriter.appendRejection(record, RejectionType.INVALID_STATE, String.format(NO_EVENT_OCCURRED_MESSAGE, this.subscriptionRecord.getElementInstanceKey(), BufferUtil.bufferAsString((DirectBuffer)this.subscriptionRecord.getMessageNameBuffer())));
        }
    }

    private boolean sendAcknowledgeCommand() {
        return this.subscriptionCommandSender.correlateMessageSubscription(this.subscriptionRecord.getSubscriptionPartitionId(), this.subscriptionRecord.getWorkflowInstanceKey(), this.subscriptionRecord.getElementInstanceKey(), this.subscriptionRecord.getMessageNameBuffer());
    }

    private boolean sendRejectionCommand() {
        return this.subscriptionCommandSender.rejectCorrelateMessageSubscription(this.subscriptionRecord.getWorkflowInstanceKey(), this.subscriptionRecord.getElementInstanceKey(), this.subscriptionRecord.getMessageKey(), this.subscriptionRecord.getMessageNameBuffer(), this.correlationKey);
    }
}

