/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message;

import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public class MessageCorrelationKeyContext {
    private long variablesScopeKey;
    private DirectBuffer variablesDocument;
    private VariablesDocumentSupplier variablesSupplier;

    public MessageCorrelationKeyContext() {
    }

    public MessageCorrelationKeyContext(VariablesDocumentSupplier variablesSupplier, long variablesScopeKey) {
        this.variablesSupplier = variablesSupplier;
        this.variablesScopeKey = variablesScopeKey;
    }

    public long getVariablesScopeKey() {
        return this.variablesScopeKey;
    }

    public MessageCorrelationKeyContext reset() {
        this.variablesSupplier = null;
        this.variablesScopeKey = -1L;
        this.variablesDocument = null;
        return this;
    }

    public MessageCorrelationKeyContext setVariablesSupplier(VariablesDocumentSupplier variablesSupplier) {
        this.variablesSupplier = variablesSupplier;
        return this;
    }

    public MessageCorrelationKeyContext setVariablesScopeKey(long variablesScopeKey) {
        this.variablesScopeKey = variablesScopeKey;
        return this;
    }

    public DirectBuffer getVariablesAsDocument() {
        DirectBuffer document;
        assert (this.variablesScopeKey >= 0L) : "no variables scope key given";
        assert (this.variablesSupplier != null) : "no variables supplier given";
        if (this.variablesDocument == null && (document = this.variablesSupplier.getVariablesAsDocument(this.variablesScopeKey)) != null) {
            this.variablesDocument = BufferUtil.cloneBuffer((DirectBuffer)document);
        }
        return this.variablesDocument;
    }

    @FunctionalInterface
    public static interface VariablesDocumentSupplier {
        public DirectBuffer getVariablesAsDocument(long var1);
    }
}

