/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message;

import io.zeebe.engine.processor.SideEffectProducer;
import io.zeebe.engine.processor.workflow.message.command.SubscriptionCommandSender;
import io.zeebe.engine.state.message.Message;
import io.zeebe.engine.state.message.MessageState;
import io.zeebe.engine.state.message.MessageSubscription;
import io.zeebe.engine.state.message.MessageSubscriptionState;
import io.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.zeebe.util.sched.clock.ActorClock;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class MessageCorrelator {
    private final DirectBuffer messageVariables = new UnsafeBuffer();
    private final MessageState messageState;
    private final MessageSubscriptionState subscriptionState;
    private final SubscriptionCommandSender commandSender;
    private Consumer<SideEffectProducer> sideEffect;
    private MessageSubscriptionRecord subscriptionRecord;
    private MessageSubscription subscription;
    private long messageKey;

    public MessageCorrelator(MessageState messageState, MessageSubscriptionState subscriptionState, SubscriptionCommandSender commandSender) {
        this.messageState = messageState;
        this.subscriptionState = subscriptionState;
        this.commandSender = commandSender;
    }

    public void correlateNextMessage(MessageSubscription subscription, MessageSubscriptionRecord subscriptionRecord, Consumer<SideEffectProducer> sideEffect) {
        this.subscription = subscription;
        this.subscriptionRecord = subscriptionRecord;
        this.sideEffect = sideEffect;
        this.messageState.visitMessages(subscription.getMessageName(), subscription.getCorrelationKey(), this::correlateMessage);
    }

    private boolean correlateMessage(Message message) {
        this.messageKey = message.getKey();
        boolean isCorrelatedBefore = this.messageState.existMessageCorrelation(this.messageKey, this.subscriptionRecord.getWorkflowInstanceKey());
        if (!isCorrelatedBefore) {
            this.subscriptionState.updateToCorrelatingState(this.subscription, message.getVariables(), ActorClock.currentTimeMillis(), this.messageKey);
            this.messageVariables.wrap(message.getVariables());
            this.sideEffect.accept(this::sendCorrelateCommand);
            this.messageState.putMessageCorrelation(this.messageKey, this.subscriptionRecord.getWorkflowInstanceKey());
        }
        return isCorrelatedBefore;
    }

    private boolean sendCorrelateCommand() {
        return this.commandSender.correlateWorkflowInstanceSubscription(this.subscriptionRecord.getWorkflowInstanceKey(), this.subscriptionRecord.getElementInstanceKey(), this.subscriptionRecord.getMessageNameBuffer(), this.messageKey, this.messageVariables);
    }
}

