/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message;

import io.zeebe.engine.processor.KeyGenerator;
import io.zeebe.engine.processor.TypedRecordProcessors;
import io.zeebe.engine.processor.workflow.message.CloseMessageStartEventSubscriptionProcessor;
import io.zeebe.engine.processor.workflow.message.CloseMessageSubscriptionProcessor;
import io.zeebe.engine.processor.workflow.message.CorrelateMessageSubscriptionProcessor;
import io.zeebe.engine.processor.workflow.message.DeleteMessageProcessor;
import io.zeebe.engine.processor.workflow.message.MessageObserver;
import io.zeebe.engine.processor.workflow.message.OpenMessageStartEventSubscriptionProcessor;
import io.zeebe.engine.processor.workflow.message.OpenMessageSubscriptionProcessor;
import io.zeebe.engine.processor.workflow.message.PublishMessageProcessor;
import io.zeebe.engine.processor.workflow.message.RejectMessageCorrelationProcessor;
import io.zeebe.engine.processor.workflow.message.command.SubscriptionCommandSender;
import io.zeebe.engine.state.ZeebeState;
import io.zeebe.engine.state.instance.EventScopeInstanceState;
import io.zeebe.engine.state.message.MessageStartEventSubscriptionState;
import io.zeebe.engine.state.message.MessageState;
import io.zeebe.engine.state.message.MessageSubscriptionState;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.MessageIntent;
import io.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.zeebe.protocol.record.intent.MessageSubscriptionIntent;

public class MessageEventProcessors {
    public static void addMessageProcessors(TypedRecordProcessors typedRecordProcessors, ZeebeState zeebeState, SubscriptionCommandSender subscriptionCommandSender) {
        MessageState messageState = zeebeState.getMessageState();
        MessageSubscriptionState subscriptionState = zeebeState.getMessageSubscriptionState();
        MessageStartEventSubscriptionState startEventSubscriptionState = zeebeState.getMessageStartEventSubscriptionState();
        EventScopeInstanceState eventScopeInstanceState = zeebeState.getWorkflowState().getEventScopeInstanceState();
        KeyGenerator keyGenerator = zeebeState.getKeyGenerator();
        typedRecordProcessors.onCommand(ValueType.MESSAGE, (Intent)MessageIntent.PUBLISH, new PublishMessageProcessor(messageState, subscriptionState, startEventSubscriptionState, eventScopeInstanceState, subscriptionCommandSender, keyGenerator)).onCommand(ValueType.MESSAGE, (Intent)MessageIntent.DELETE, new DeleteMessageProcessor(messageState)).onCommand(ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.OPEN, new OpenMessageSubscriptionProcessor(messageState, subscriptionState, subscriptionCommandSender)).onCommand(ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CORRELATE, new CorrelateMessageSubscriptionProcessor(messageState, subscriptionState, subscriptionCommandSender)).onCommand(ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CLOSE, new CloseMessageSubscriptionProcessor(subscriptionState, subscriptionCommandSender)).onCommand(ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.REJECT, new RejectMessageCorrelationProcessor(messageState, subscriptionState, subscriptionCommandSender)).onCommand(ValueType.MESSAGE_START_EVENT_SUBSCRIPTION, (Intent)MessageStartEventSubscriptionIntent.OPEN, new OpenMessageStartEventSubscriptionProcessor(startEventSubscriptionState, zeebeState.getWorkflowState())).onCommand(ValueType.MESSAGE_START_EVENT_SUBSCRIPTION, (Intent)MessageStartEventSubscriptionIntent.CLOSE, new CloseMessageStartEventSubscriptionProcessor(startEventSubscriptionState)).withListener(new MessageObserver(messageState, subscriptionState, subscriptionCommandSender));
    }
}

