/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message;

import io.zeebe.engine.processor.ReadonlyProcessingContext;
import io.zeebe.engine.processor.StreamProcessorLifecycleAware;
import io.zeebe.engine.processor.TypedStreamWriterImpl;
import io.zeebe.engine.processor.workflow.message.MessageTimeToLiveChecker;
import io.zeebe.engine.processor.workflow.message.PendingMessageSubscriptionChecker;
import io.zeebe.engine.processor.workflow.message.command.SubscriptionCommandSender;
import io.zeebe.engine.state.message.MessageState;
import io.zeebe.engine.state.message.MessageSubscriptionState;
import io.zeebe.util.sched.ActorControl;
import java.time.Duration;

public class MessageObserver
implements StreamProcessorLifecycleAware {
    public static final Duration MESSAGE_TIME_TO_LIVE_CHECK_INTERVAL = Duration.ofSeconds(60L);
    public static final Duration SUBSCRIPTION_TIMEOUT = Duration.ofSeconds(10L);
    public static final Duration SUBSCRIPTION_CHECK_INTERVAL = Duration.ofSeconds(30L);
    private final SubscriptionCommandSender subscriptionCommandSender;
    private final MessageState messageState;
    private final MessageSubscriptionState subscriptionState;

    public MessageObserver(MessageState messageState, MessageSubscriptionState subscriptionState, SubscriptionCommandSender subscriptionCommandSender) {
        this.subscriptionCommandSender = subscriptionCommandSender;
        this.messageState = messageState;
        this.subscriptionState = subscriptionState;
    }

    @Override
    public void onOpen(ReadonlyProcessingContext processingContext) {
        ActorControl actor = processingContext.getActor();
        TypedStreamWriterImpl typedStreamWriter = new TypedStreamWriterImpl(processingContext.getLogStream());
        MessageTimeToLiveChecker timeToLiveChecker = new MessageTimeToLiveChecker(typedStreamWriter, this.messageState);
        processingContext.getActor().runAtFixedRate(MESSAGE_TIME_TO_LIVE_CHECK_INTERVAL, (Runnable)timeToLiveChecker);
        PendingMessageSubscriptionChecker pendingSubscriptionChecker = new PendingMessageSubscriptionChecker(this.subscriptionCommandSender, this.subscriptionState, SUBSCRIPTION_TIMEOUT.toMillis());
        actor.runAtFixedRate(SUBSCRIPTION_CHECK_INTERVAL, (Runnable)pendingSubscriptionChecker);
    }
}

