/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message;

import io.zeebe.engine.processor.TypedCommandWriter;
import io.zeebe.engine.state.message.Message;
import io.zeebe.engine.state.message.MessageState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.MessageIntent;
import io.zeebe.util.sched.clock.ActorClock;

public class MessageTimeToLiveChecker
implements Runnable {
    private final TypedCommandWriter writer;
    private final MessageState messageState;
    private final MessageRecord deleteMessageCommand = new MessageRecord();

    public MessageTimeToLiveChecker(TypedCommandWriter writer, MessageState messageState) {
        this.writer = writer;
        this.messageState = messageState;
    }

    @Override
    public void run() {
        this.messageState.visitMessagesWithDeadlineBefore(ActorClock.currentTimeMillis(), this::writeDeleteMessageCommand);
    }

    private boolean writeDeleteMessageCommand(Message message) {
        this.deleteMessageCommand.reset();
        this.deleteMessageCommand.setName(message.getName()).setCorrelationKey(message.getCorrelationKey()).setTimeToLive(message.getTimeToLive()).setVariables(message.getVariables());
        if (message.getId() != null) {
            this.deleteMessageCommand.setMessageId(message.getId());
        }
        this.writer.appendFollowUpCommand(message.getKey(), (Intent)MessageIntent.DELETE, (UnpackedObject)this.deleteMessageCommand);
        long position = this.writer.flush();
        return position > 0L;
    }
}

