/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message;

import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.engine.state.message.MessageStartEventSubscriptionState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import java.util.Collections;

public class OpenMessageStartEventSubscriptionProcessor
implements TypedRecordProcessor<MessageStartEventSubscriptionRecord> {
    private final MessageStartEventSubscriptionState subscriptionState;
    private final WorkflowState workflowState;

    public OpenMessageStartEventSubscriptionProcessor(MessageStartEventSubscriptionState subscriptionState, WorkflowState workflowState) {
        this.subscriptionState = subscriptionState;
        this.workflowState = workflowState;
    }

    @Override
    public void processRecord(TypedRecord<MessageStartEventSubscriptionRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        MessageStartEventSubscriptionRecord subscription = record.getValue();
        this.subscriptionState.put(subscription);
        this.workflowState.getEventScopeInstanceState().createIfNotExists(subscription.getWorkflowKey(), Collections.emptyList());
        streamWriter.appendFollowUpEvent(record.getKey(), (Intent)MessageStartEventSubscriptionIntent.OPENED, (UnpackedObject)subscription);
    }
}

