/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message;

import io.zeebe.engine.processor.SideEffectProducer;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.processor.workflow.message.MessageCorrelator;
import io.zeebe.engine.processor.workflow.message.command.SubscriptionCommandSender;
import io.zeebe.engine.state.message.MessageState;
import io.zeebe.engine.state.message.MessageSubscription;
import io.zeebe.engine.state.message.MessageSubscriptionState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.zeebe.util.buffer.BufferUtil;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;

public class OpenMessageSubscriptionProcessor
implements TypedRecordProcessor<MessageSubscriptionRecord> {
    public static final String SUBSCRIPTION_ALREADY_OPENED_MESSAGE = "Expected to open a new message subscription for element with key '%d' and message name '%s', but there is already a message subscription for that element key and message name opened";
    private final MessageCorrelator messageCorrelator;
    private final MessageSubscriptionState subscriptionState;
    private final SubscriptionCommandSender commandSender;
    private MessageSubscriptionRecord subscriptionRecord;

    public OpenMessageSubscriptionProcessor(MessageState messageState, MessageSubscriptionState subscriptionState, SubscriptionCommandSender commandSender) {
        this.subscriptionState = subscriptionState;
        this.commandSender = commandSender;
        this.messageCorrelator = new MessageCorrelator(messageState, subscriptionState, commandSender);
    }

    @Override
    public void processRecord(TypedRecord<MessageSubscriptionRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        this.subscriptionRecord = record.getValue();
        if (this.subscriptionState.existSubscriptionForElementInstance(this.subscriptionRecord.getElementInstanceKey(), this.subscriptionRecord.getMessageNameBuffer())) {
            sideEffect.accept(this::sendAcknowledgeCommand);
            streamWriter.appendRejection(record, RejectionType.INVALID_STATE, String.format(SUBSCRIPTION_ALREADY_OPENED_MESSAGE, this.subscriptionRecord.getElementInstanceKey(), BufferUtil.bufferAsString((DirectBuffer)this.subscriptionRecord.getMessageNameBuffer())));
            return;
        }
        this.handleNewSubscription(record, streamWriter, sideEffect);
    }

    private void handleNewSubscription(TypedRecord<MessageSubscriptionRecord> record, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        MessageSubscription subscription = new MessageSubscription(this.subscriptionRecord.getWorkflowInstanceKey(), this.subscriptionRecord.getElementInstanceKey(), this.subscriptionRecord.getMessageNameBuffer(), this.subscriptionRecord.getCorrelationKeyBuffer(), this.subscriptionRecord.shouldCloseOnCorrelate());
        sideEffect.accept(this::sendAcknowledgeCommand);
        this.subscriptionState.put(subscription);
        this.messageCorrelator.correlateNextMessage(subscription, this.subscriptionRecord, sideEffect);
        streamWriter.appendFollowUpEvent(record.getKey(), (Intent)MessageSubscriptionIntent.OPENED, (UnpackedObject)this.subscriptionRecord);
    }

    private boolean sendAcknowledgeCommand() {
        return this.commandSender.openWorkflowInstanceSubscription(this.subscriptionRecord.getWorkflowInstanceKey(), this.subscriptionRecord.getElementInstanceKey(), this.subscriptionRecord.getMessageNameBuffer(), this.subscriptionRecord.shouldCloseOnCorrelate());
    }
}

