/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message;

import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.state.message.WorkflowInstanceSubscription;
import io.zeebe.engine.state.message.WorkflowInstanceSubscriptionState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.message.WorkflowInstanceSubscriptionRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.WorkflowInstanceSubscriptionIntent;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public class OpenWorkflowInstanceSubscriptionProcessor
implements TypedRecordProcessor<WorkflowInstanceSubscriptionRecord> {
    public static final String NO_SUBSCRIPTION_FOUND_MESSAGE = "Expected to open workflow instance subscription with element key '%d' and message name '%s', but no such subscription was found";
    public static final String NOT_OPENING_MSG = "Expected to open workflow instance subscription with element key '%d' and message name '%s', but it is already %s";
    private final WorkflowInstanceSubscriptionState subscriptionState;

    public OpenWorkflowInstanceSubscriptionProcessor(WorkflowInstanceSubscriptionState subscriptionState) {
        this.subscriptionState = subscriptionState;
    }

    @Override
    public void processRecord(TypedRecord<WorkflowInstanceSubscriptionRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        WorkflowInstanceSubscriptionRecord subscriptionRecord = record.getValue();
        WorkflowInstanceSubscription subscription = this.subscriptionState.getSubscription(subscriptionRecord.getElementInstanceKey(), subscriptionRecord.getMessageNameBuffer());
        if (subscription != null && subscription.isOpening()) {
            this.subscriptionState.updateToOpenedState(subscription, subscription.getSubscriptionPartitionId());
            streamWriter.appendFollowUpEvent(record.getKey(), (Intent)WorkflowInstanceSubscriptionIntent.OPENED, (UnpackedObject)subscriptionRecord);
        } else {
            String messageName = BufferUtil.bufferAsString((DirectBuffer)subscriptionRecord.getMessageNameBuffer());
            if (subscription == null) {
                streamWriter.appendRejection(record, RejectionType.NOT_FOUND, String.format(NO_SUBSCRIPTION_FOUND_MESSAGE, subscriptionRecord.getElementInstanceKey(), messageName));
            } else {
                String state = subscription.isClosing() ? "closing" : "opened";
                streamWriter.appendRejection(record, RejectionType.INVALID_STATE, String.format(NOT_OPENING_MSG, subscriptionRecord.getElementInstanceKey(), messageName, state));
            }
        }
    }
}

