/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message;

import io.zeebe.engine.processor.workflow.message.command.SubscriptionCommandSender;
import io.zeebe.engine.state.message.MessageSubscription;
import io.zeebe.engine.state.message.MessageSubscriptionState;
import io.zeebe.util.sched.clock.ActorClock;

public class PendingMessageSubscriptionChecker
implements Runnable {
    private final SubscriptionCommandSender commandSender;
    private final MessageSubscriptionState subscriptionState;
    private final long subscriptionTimeout;

    public PendingMessageSubscriptionChecker(SubscriptionCommandSender commandSender, MessageSubscriptionState subscriptionState, long subscriptionTimeout) {
        this.commandSender = commandSender;
        this.subscriptionState = subscriptionState;
        this.subscriptionTimeout = subscriptionTimeout;
    }

    @Override
    public void run() {
        this.subscriptionState.visitSubscriptionBefore(ActorClock.currentTimeMillis() - this.subscriptionTimeout, this::sendCommand);
    }

    private boolean sendCommand(MessageSubscription subscription) {
        boolean success = this.commandSender.correlateWorkflowInstanceSubscription(subscription.getWorkflowInstanceKey(), subscription.getElementInstanceKey(), subscription.getMessageName(), subscription.getMessageKey(), subscription.getMessageVariables());
        if (success) {
            this.subscriptionState.updateSentTimeInTransaction(subscription, ActorClock.currentTimeMillis());
        }
        return success;
    }
}

