/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message;

import io.zeebe.engine.processor.workflow.message.command.SubscriptionCommandSender;
import io.zeebe.engine.state.message.WorkflowInstanceSubscription;
import io.zeebe.engine.state.message.WorkflowInstanceSubscriptionState;
import io.zeebe.util.sched.clock.ActorClock;

public class PendingWorkflowInstanceSubscriptionChecker
implements Runnable {
    private final SubscriptionCommandSender commandSender;
    private final WorkflowInstanceSubscriptionState subscriptionState;
    private final long subscriptionTimeout;

    public PendingWorkflowInstanceSubscriptionChecker(SubscriptionCommandSender commandSender, WorkflowInstanceSubscriptionState subscriptionState, long subscriptionTimeout) {
        this.commandSender = commandSender;
        this.subscriptionState = subscriptionState;
        this.subscriptionTimeout = subscriptionTimeout;
    }

    @Override
    public void run() {
        this.subscriptionState.visitSubscriptionBefore(ActorClock.currentTimeMillis() - this.subscriptionTimeout, this::sendCommand);
    }

    private boolean sendCommand(WorkflowInstanceSubscription subscription) {
        boolean success = subscription.isOpening() ? this.sendOpenCommand(subscription) : this.sendCloseCommand(subscription);
        if (success) {
            this.subscriptionState.updateSentTimeInTransaction(subscription, ActorClock.currentTimeMillis());
        }
        return success;
    }

    private boolean sendOpenCommand(WorkflowInstanceSubscription subscription) {
        return this.commandSender.openMessageSubscription(subscription.getSubscriptionPartitionId(), subscription.getWorkflowInstanceKey(), subscription.getElementInstanceKey(), subscription.getMessageName(), subscription.getCorrelationKey(), subscription.shouldCloseOnCorrelate());
    }

    private boolean sendCloseCommand(WorkflowInstanceSubscription subscription) {
        return this.commandSender.closeMessageSubscription(subscription.getSubscriptionPartitionId(), subscription.getWorkflowInstanceKey(), subscription.getElementInstanceKey(), subscription.getMessageName());
    }
}

