/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message;

import io.zeebe.engine.Loggers;
import io.zeebe.engine.processor.KeyGenerator;
import io.zeebe.engine.processor.SideEffectProducer;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.processor.workflow.message.command.SubscriptionCommandSender;
import io.zeebe.engine.state.instance.EventScopeInstanceState;
import io.zeebe.engine.state.message.Message;
import io.zeebe.engine.state.message.MessageStartEventSubscriptionState;
import io.zeebe.engine.state.message.MessageState;
import io.zeebe.engine.state.message.MessageSubscriptionState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.MessageIntent;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.protocol.record.value.BpmnElementType;
import io.zeebe.util.buffer.BufferUtil;
import io.zeebe.util.sched.clock.ActorClock;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.collections.LongArrayList;

public class PublishMessageProcessor
implements TypedRecordProcessor<MessageRecord> {
    private static final String ALREADY_PUBLISHED_MESSAGE = "Expected to publish a new message with id '%s', but a message with that id was already published";
    public static final String ERROR_START_EVENT_NOT_TRIGGERED_MESSAGE = "Expected to trigger event for workflow with key '%d', but could not (either does not exist or is not accepting)";
    private final MessageState messageState;
    private final MessageSubscriptionState subscriptionState;
    private final MessageStartEventSubscriptionState startEventSubscriptionState;
    private final SubscriptionCommandSender commandSender;
    private final KeyGenerator keyGenerator;
    private final EventScopeInstanceState scopeEventInstanceState;
    private TypedResponseWriter responseWriter;
    private MessageRecord messageRecord;
    private long messageKey;
    private final LongArrayList correlatedWorkflowInstances = new LongArrayList();
    private final LongArrayList correlatedElementInstances = new LongArrayList();

    public PublishMessageProcessor(MessageState messageState, MessageSubscriptionState subscriptionState, MessageStartEventSubscriptionState startEventSubscriptionState, EventScopeInstanceState scopeEventInstanceState, SubscriptionCommandSender commandSender, KeyGenerator keyGenerator) {
        this.messageState = messageState;
        this.subscriptionState = subscriptionState;
        this.startEventSubscriptionState = startEventSubscriptionState;
        this.scopeEventInstanceState = scopeEventInstanceState;
        this.commandSender = commandSender;
        this.keyGenerator = keyGenerator;
    }

    @Override
    public void processRecord(TypedRecord<MessageRecord> command, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        this.responseWriter = responseWriter;
        this.messageRecord = command.getValue();
        if (this.messageRecord.hasMessageId() && this.messageState.exist(this.messageRecord.getNameBuffer(), this.messageRecord.getCorrelationKeyBuffer(), this.messageRecord.getMessageIdBuffer())) {
            String rejectionReason = String.format(ALREADY_PUBLISHED_MESSAGE, BufferUtil.bufferAsString((DirectBuffer)this.messageRecord.getMessageIdBuffer()));
            streamWriter.appendRejection(command, RejectionType.ALREADY_EXISTS, rejectionReason);
            responseWriter.writeRejectionOnCommand(command, RejectionType.ALREADY_EXISTS, rejectionReason);
        } else {
            this.handleNewMessage(command, responseWriter, streamWriter, sideEffect);
        }
    }

    private void handleNewMessage(TypedRecord<MessageRecord> command, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        this.messageKey = this.keyGenerator.nextKey();
        streamWriter.appendNewEvent(this.messageKey, (Intent)MessageIntent.PUBLISHED, (UnpackedObject)command.getValue());
        responseWriter.writeEventOnCommand(this.messageKey, (Intent)MessageIntent.PUBLISHED, (UnpackedObject)command.getValue(), command);
        this.correlatedWorkflowInstances.clear();
        this.correlatedElementInstances.clear();
        this.subscriptionState.visitSubscriptions(this.messageRecord.getNameBuffer(), this.messageRecord.getCorrelationKeyBuffer(), subscription -> {
            long workflowInstanceKey = subscription.getWorkflowInstanceKey();
            long elementInstanceKey = subscription.getElementInstanceKey();
            if (!subscription.isCorrelating() && !this.correlatedWorkflowInstances.containsLong(workflowInstanceKey)) {
                this.subscriptionState.updateToCorrelatingState(subscription, this.messageRecord.getVariablesBuffer(), ActorClock.currentTimeMillis(), this.messageKey);
                this.correlatedWorkflowInstances.addLong(workflowInstanceKey);
                this.correlatedElementInstances.addLong(elementInstanceKey);
            }
            return true;
        });
        sideEffect.accept(this::correlateMessage);
        this.correlateMessageStartEvents(command, streamWriter);
        if (this.messageRecord.getTimeToLive() > 0L) {
            Message message = new Message(this.messageKey, this.messageRecord.getNameBuffer(), this.messageRecord.getCorrelationKeyBuffer(), this.messageRecord.getVariablesBuffer(), this.messageRecord.getMessageIdBuffer(), this.messageRecord.getTimeToLive(), this.messageRecord.getTimeToLive() + ActorClock.currentTimeMillis());
            this.messageState.put(message);
            this.correlatedWorkflowInstances.forEachOrderedLong(workflowInstanceKey -> this.messageState.putMessageCorrelation(message.getKey(), workflowInstanceKey));
        } else {
            streamWriter.appendFollowUpEvent(this.messageKey, (Intent)MessageIntent.DELETED, (UnpackedObject)this.messageRecord);
        }
    }

    private boolean correlateMessage() {
        for (int i = 0; i < this.correlatedWorkflowInstances.size(); ++i) {
            long elementInstanceKey;
            long workflowInstanceKey = this.correlatedWorkflowInstances.getLong(i);
            boolean success = this.commandSender.correlateWorkflowInstanceSubscription(workflowInstanceKey, elementInstanceKey = this.correlatedElementInstances.getLong(i), this.messageRecord.getNameBuffer(), this.messageKey, this.messageRecord.getVariablesBuffer());
            if (success) continue;
            return false;
        }
        return this.responseWriter.flush();
    }

    private void correlateMessageStartEvents(TypedRecord<MessageRecord> command, TypedStreamWriter streamWriter) {
        DirectBuffer messageName = command.getValue().getNameBuffer();
        this.startEventSubscriptionState.visitSubscriptionsByMessageName(messageName, subscription -> this.visitStartEventSubscription(command, streamWriter, subscription));
    }

    private void visitStartEventSubscription(TypedRecord<MessageRecord> command, TypedStreamWriter streamWriter, MessageStartEventSubscriptionRecord subscription) {
        DirectBuffer startEventId = subscription.getStartEventIdBuffer();
        long workflowKey = subscription.getWorkflowKey();
        WorkflowInstanceRecord record = new WorkflowInstanceRecord().setWorkflowKey(workflowKey).setElementId(startEventId).setBpmnElementType(BpmnElementType.START_EVENT);
        long eventKey = this.keyGenerator.nextKey();
        boolean wasTriggered = this.scopeEventInstanceState.triggerEvent(workflowKey, eventKey, startEventId, command.getValue().getVariablesBuffer());
        if (wasTriggered) {
            streamWriter.appendNewEvent(eventKey, (Intent)WorkflowInstanceIntent.EVENT_OCCURRED, (UnpackedObject)record);
        } else {
            Loggers.WORKFLOW_PROCESSOR_LOGGER.error(String.format(ERROR_START_EVENT_NOT_TRIGGERED_MESSAGE, workflowKey));
        }
    }
}

