/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message;

import io.zeebe.engine.processor.SideEffectProducer;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.processor.workflow.message.command.SubscriptionCommandSender;
import io.zeebe.engine.state.message.Message;
import io.zeebe.engine.state.message.MessageState;
import io.zeebe.engine.state.message.MessageSubscription;
import io.zeebe.engine.state.message.MessageSubscriptionState;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.zeebe.util.sched.clock.ActorClock;
import java.util.function.Consumer;

public class RejectMessageCorrelationProcessor
implements TypedRecordProcessor<MessageSubscriptionRecord> {
    private final MessageState messageState;
    private final MessageSubscriptionState subscriptionState;
    private final SubscriptionCommandSender commandSender;
    private MessageSubscription subscription;

    public RejectMessageCorrelationProcessor(MessageState messageState, MessageSubscriptionState subscriptionState, SubscriptionCommandSender commandSender) {
        this.messageState = messageState;
        this.subscriptionState = subscriptionState;
        this.commandSender = commandSender;
    }

    @Override
    public void processRecord(TypedRecord<MessageSubscriptionRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        long workflowInstanceKey;
        MessageSubscriptionRecord subscriptionRecord = record.getValue();
        long messageKey = subscriptionRecord.getMessageKey();
        if (!this.messageState.existMessageCorrelation(messageKey, workflowInstanceKey = subscriptionRecord.getWorkflowInstanceKey())) {
            streamWriter.appendRejection(record, RejectionType.INVALID_STATE, String.format("Expected message %d to be correlated in workflow instance %d but no correlation was found", messageKey, workflowInstanceKey));
            return;
        }
        this.messageState.removeMessageCorrelation(messageKey, workflowInstanceKey);
        this.findSubscriptionToCorrelate(sideEffect, subscriptionRecord, messageKey, workflowInstanceKey);
        streamWriter.appendFollowUpEvent(record.getKey(), (Intent)MessageSubscriptionIntent.REJECTED, (UnpackedObject)record.getValue());
    }

    private void findSubscriptionToCorrelate(Consumer<SideEffectProducer> sideEffect, MessageSubscriptionRecord subscriptionRecord, long messageKey, long workflowInstanceKey) {
        Message message = this.messageState.getMessage(messageKey);
        if (message == null) {
            return;
        }
        this.subscriptionState.visitSubscriptions(subscriptionRecord.getMessageNameBuffer(), subscriptionRecord.getCorrelationKeyBuffer(), subscription -> {
            if (subscription.getWorkflowInstanceKey() == workflowInstanceKey && !subscription.isCorrelating()) {
                subscription.setMessageKey(messageKey);
                subscription.setMessageVariables(message.getVariables());
                this.correlateMessage(subscription, sideEffect);
                return false;
            }
            return true;
        });
    }

    private void correlateMessage(MessageSubscription subscription, Consumer<SideEffectProducer> sideEffect) {
        this.subscriptionState.updateToCorrelatingState(subscription, subscription.getMessageVariables(), ActorClock.currentTimeMillis(), subscription.getMessageKey());
        this.messageState.putMessageCorrelation(subscription.getMessageKey(), subscription.getWorkflowInstanceKey());
        this.subscription = subscription;
        sideEffect.accept(this::sendCorrelateCommand);
    }

    private boolean sendCorrelateCommand() {
        return this.commandSender.correlateWorkflowInstanceSubscription(this.subscription.getWorkflowInstanceKey(), this.subscription.getElementInstanceKey(), this.subscription.getMessageName(), this.subscription.getMessageKey(), this.subscription.getMessageVariables());
    }
}

