/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message.command;

import io.zeebe.engine.processor.workflow.message.command.CloseMessageSubscriptionDecoder;
import io.zeebe.engine.processor.workflow.message.command.CloseMessageSubscriptionEncoder;
import io.zeebe.engine.util.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class CloseMessageSubscriptionCommand
extends SbeBufferWriterReader<CloseMessageSubscriptionEncoder, CloseMessageSubscriptionDecoder> {
    private final CloseMessageSubscriptionEncoder encoder = new CloseMessageSubscriptionEncoder();
    private final CloseMessageSubscriptionDecoder decoder = new CloseMessageSubscriptionDecoder();
    private final DirectBuffer messageName = new UnsafeBuffer(0L, 0);
    private int subscriptionPartitionId;
    private long workflowInstanceKey;
    private long elementInstanceKey;

    @Override
    protected CloseMessageSubscriptionEncoder getBodyEncoder() {
        return this.encoder;
    }

    @Override
    protected CloseMessageSubscriptionDecoder getBodyDecoder() {
        return this.decoder;
    }

    @Override
    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.subscriptionPartitionId(this.subscriptionPartitionId).workflowInstanceKey(this.workflowInstanceKey).elementInstanceKey(this.elementInstanceKey).putMessageName(this.messageName, 0, this.messageName.capacity());
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.subscriptionPartitionId = this.decoder.subscriptionPartitionId();
        this.workflowInstanceKey = this.decoder.workflowInstanceKey();
        this.elementInstanceKey = this.decoder.elementInstanceKey();
        this.decoder.wrapMessageName(this.messageName);
    }

    @Override
    public void reset() {
        this.subscriptionPartitionId = CloseMessageSubscriptionDecoder.subscriptionPartitionIdNullValue();
        this.workflowInstanceKey = CloseMessageSubscriptionDecoder.workflowInstanceKeyNullValue();
        this.elementInstanceKey = CloseMessageSubscriptionDecoder.elementInstanceKeyNullValue();
        this.messageName.wrap(0L, 0);
    }

    @Override
    public int getLength() {
        return super.getLength() + CloseMessageSubscriptionDecoder.messageNameHeaderLength() + this.messageName.capacity();
    }

    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionId;
    }

    public void setSubscriptionPartitionId(int subscriptionPartitionId) {
        this.subscriptionPartitionId = subscriptionPartitionId;
    }

    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKey;
    }

    public void setWorkflowInstanceKey(long workflowInstanceKey) {
        this.workflowInstanceKey = workflowInstanceKey;
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public void setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public DirectBuffer getMessageName() {
        return this.messageName;
    }

    public void setMessageName(DirectBuffer messageName) {
        this.messageName.wrap(messageName);
    }
}

