/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message.command;

import io.zeebe.engine.processor.workflow.message.command.CloseWorkflowInstanceSubscriptionDecoder;
import io.zeebe.engine.processor.workflow.message.command.CloseWorkflowInstanceSubscriptionEncoder;
import io.zeebe.engine.util.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class CloseWorkflowInstanceSubscriptionCommand
extends SbeBufferWriterReader<CloseWorkflowInstanceSubscriptionEncoder, CloseWorkflowInstanceSubscriptionDecoder> {
    private final CloseWorkflowInstanceSubscriptionEncoder encoder = new CloseWorkflowInstanceSubscriptionEncoder();
    private final CloseWorkflowInstanceSubscriptionDecoder decoder = new CloseWorkflowInstanceSubscriptionDecoder();
    private final DirectBuffer messageName = new UnsafeBuffer(0L, 0);
    private int subscriptionPartitionId;
    private long workflowInstanceKey;
    private long elementInstanceKey;

    @Override
    protected CloseWorkflowInstanceSubscriptionEncoder getBodyEncoder() {
        return this.encoder;
    }

    @Override
    protected CloseWorkflowInstanceSubscriptionDecoder getBodyDecoder() {
        return this.decoder;
    }

    @Override
    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.subscriptionPartitionId(this.subscriptionPartitionId).workflowInstanceKey(this.workflowInstanceKey).elementInstanceKey(this.elementInstanceKey).putMessageName(this.messageName, 0, this.messageName.capacity());
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.subscriptionPartitionId = this.decoder.subscriptionPartitionId();
        this.workflowInstanceKey = this.decoder.workflowInstanceKey();
        this.elementInstanceKey = this.decoder.elementInstanceKey();
        this.decoder.wrapMessageName(this.messageName);
    }

    @Override
    public void reset() {
        this.subscriptionPartitionId = CloseWorkflowInstanceSubscriptionDecoder.subscriptionPartitionIdNullValue();
        this.workflowInstanceKey = CloseWorkflowInstanceSubscriptionDecoder.workflowInstanceKeyNullValue();
        this.elementInstanceKey = CloseWorkflowInstanceSubscriptionDecoder.elementInstanceKeyNullValue();
        this.messageName.wrap(0L, 0);
    }

    @Override
    public int getLength() {
        return super.getLength() + CloseWorkflowInstanceSubscriptionDecoder.messageNameHeaderLength() + this.messageName.capacity();
    }

    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionId;
    }

    public void setSubscriptionPartitionId(int subscriptionPartitionId) {
        this.subscriptionPartitionId = subscriptionPartitionId;
    }

    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKey;
    }

    public void setWorkflowInstanceKey(long workflowInstanceKey) {
        this.workflowInstanceKey = workflowInstanceKey;
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public void setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public DirectBuffer getMessageName() {
        return this.messageName;
    }

    public void setMessageName(DirectBuffer messageName) {
        this.messageName.wrap(messageName);
    }
}

