/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message.command;

import io.zeebe.engine.processor.workflow.message.command.CorrelateMessageSubscriptionDecoder;
import io.zeebe.engine.processor.workflow.message.command.CorrelateMessageSubscriptionEncoder;
import io.zeebe.engine.util.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class CorrelateMessageSubscriptionCommand
extends SbeBufferWriterReader<CorrelateMessageSubscriptionEncoder, CorrelateMessageSubscriptionDecoder> {
    private final CorrelateMessageSubscriptionEncoder encoder = new CorrelateMessageSubscriptionEncoder();
    private final CorrelateMessageSubscriptionDecoder decoder = new CorrelateMessageSubscriptionDecoder();
    private int subscriptionPartitionId;
    private long workflowInstanceKey;
    private long elementInstanceKey;
    private final UnsafeBuffer messageName = new UnsafeBuffer(0L, 0);

    @Override
    protected CorrelateMessageSubscriptionEncoder getBodyEncoder() {
        return this.encoder;
    }

    @Override
    protected CorrelateMessageSubscriptionDecoder getBodyDecoder() {
        return this.decoder;
    }

    @Override
    public int getLength() {
        return super.getLength() + CorrelateMessageSubscriptionDecoder.messageNameHeaderLength() + this.messageName.capacity();
    }

    @Override
    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.subscriptionPartitionId(this.subscriptionPartitionId).workflowInstanceKey(this.workflowInstanceKey).elementInstanceKey(this.elementInstanceKey).putMessageName((DirectBuffer)this.messageName, 0, this.messageName.capacity());
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.subscriptionPartitionId = this.decoder.subscriptionPartitionId();
        this.workflowInstanceKey = this.decoder.workflowInstanceKey();
        this.elementInstanceKey = this.decoder.elementInstanceKey();
        offset = this.decoder.limit();
        int messageNameLength = this.decoder.messageNameLength();
        this.messageName.wrap(buffer, offset += CorrelateMessageSubscriptionDecoder.messageNameHeaderLength(), messageNameLength);
    }

    @Override
    public void reset() {
        this.subscriptionPartitionId = CorrelateMessageSubscriptionDecoder.subscriptionPartitionIdNullValue();
        this.workflowInstanceKey = CorrelateMessageSubscriptionDecoder.workflowInstanceKeyNullValue();
        this.elementInstanceKey = CorrelateMessageSubscriptionDecoder.elementInstanceKeyNullValue();
        this.messageName.wrap(0L, 0);
    }

    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionId;
    }

    public void setSubscriptionPartitionId(int subscriptionPartitionId) {
        this.subscriptionPartitionId = subscriptionPartitionId;
    }

    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKey;
    }

    public void setWorkflowInstanceKey(long workflowInstanceKey) {
        this.workflowInstanceKey = workflowInstanceKey;
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public void setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public DirectBuffer getMessageName() {
        return this.messageName;
    }
}

