/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message.command;

import io.zeebe.engine.processor.workflow.message.command.CorrelateWorkflowInstanceSubscriptionDecoder;
import io.zeebe.engine.processor.workflow.message.command.CorrelateWorkflowInstanceSubscriptionEncoder;
import io.zeebe.engine.util.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class CorrelateWorkflowInstanceSubscriptionCommand
extends SbeBufferWriterReader<CorrelateWorkflowInstanceSubscriptionEncoder, CorrelateWorkflowInstanceSubscriptionDecoder> {
    private final CorrelateWorkflowInstanceSubscriptionEncoder encoder = new CorrelateWorkflowInstanceSubscriptionEncoder();
    private final CorrelateWorkflowInstanceSubscriptionDecoder decoder = new CorrelateWorkflowInstanceSubscriptionDecoder();
    private int subscriptionPartitionId;
    private long workflowInstanceKey;
    private long elementInstanceKey;
    private long messageKey;
    private final UnsafeBuffer messageName = new UnsafeBuffer(0L, 0);
    private final UnsafeBuffer variables = new UnsafeBuffer(0L, 0);

    @Override
    protected CorrelateWorkflowInstanceSubscriptionEncoder getBodyEncoder() {
        return this.encoder;
    }

    @Override
    protected CorrelateWorkflowInstanceSubscriptionDecoder getBodyDecoder() {
        return this.decoder;
    }

    @Override
    public int getLength() {
        return super.getLength() + CorrelateWorkflowInstanceSubscriptionDecoder.messageNameHeaderLength() + this.messageName.capacity() + CorrelateWorkflowInstanceSubscriptionDecoder.variablesHeaderLength() + this.variables.capacity();
    }

    @Override
    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.subscriptionPartitionId(this.subscriptionPartitionId).workflowInstanceKey(this.workflowInstanceKey).elementInstanceKey(this.elementInstanceKey).messageKey(this.messageKey).putMessageName((DirectBuffer)this.messageName, 0, this.messageName.capacity()).putVariables((DirectBuffer)this.variables, 0, this.variables.capacity());
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.subscriptionPartitionId = this.decoder.subscriptionPartitionId();
        this.workflowInstanceKey = this.decoder.workflowInstanceKey();
        this.elementInstanceKey = this.decoder.elementInstanceKey();
        this.messageKey = this.decoder.messageKey();
        offset = this.decoder.limit();
        int messageNameLength = this.decoder.messageNameLength();
        this.messageName.wrap(buffer, offset += CorrelateWorkflowInstanceSubscriptionDecoder.messageNameHeaderLength(), messageNameLength);
        this.decoder.limit(offset += messageNameLength);
        int variablesLength = this.decoder.variablesLength();
        this.variables.wrap(buffer, offset += CorrelateWorkflowInstanceSubscriptionDecoder.variablesHeaderLength(), variablesLength);
        this.decoder.limit(offset += variablesLength);
    }

    @Override
    public void reset() {
        this.subscriptionPartitionId = CorrelateWorkflowInstanceSubscriptionDecoder.subscriptionPartitionIdNullValue();
        this.workflowInstanceKey = CorrelateWorkflowInstanceSubscriptionDecoder.workflowInstanceKeyNullValue();
        this.elementInstanceKey = CorrelateWorkflowInstanceSubscriptionDecoder.elementInstanceKeyNullValue();
        this.messageKey = CorrelateWorkflowInstanceSubscriptionDecoder.messageKeyNullValue();
        this.messageName.wrap(0L, 0);
        this.variables.wrap(0L, 0);
    }

    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionId;
    }

    public void setSubscriptionPartitionId(int subscriptionPartitionId) {
        this.subscriptionPartitionId = subscriptionPartitionId;
    }

    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKey;
    }

    public void setWorkflowInstanceKey(long workflowInstanceKey) {
        this.workflowInstanceKey = workflowInstanceKey;
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public void setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public long getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(long messageKey) {
        this.messageKey = messageKey;
    }

    public DirectBuffer getMessageName() {
        return this.messageName;
    }

    public DirectBuffer getVariables() {
        return this.variables;
    }
}

