/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message.command;

import io.zeebe.engine.processor.workflow.message.command.CorrelateWorkflowInstanceSubscriptionDecoder;
import io.zeebe.engine.processor.workflow.message.command.MessageHeaderEncoder;
import io.zeebe.engine.processor.workflow.message.command.MetaAttribute;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public class CorrelateWorkflowInstanceSubscriptionEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 26;
    public static final int TEMPLATE_ID = 2;
    public static final int SCHEMA_ID = 6;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final CorrelateWorkflowInstanceSubscriptionEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 26;
    }

    public int sbeTemplateId() {
        return 2;
    }

    public int sbeSchemaId() {
        return 6;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public CorrelateWorkflowInstanceSubscriptionEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 26);
        return this;
    }

    public CorrelateWorkflowInstanceSubscriptionEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(26).templateId(2).schemaId(6).version(1);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int subscriptionPartitionIdId() {
        return 0;
    }

    public static int subscriptionPartitionIdSinceVersion() {
        return 0;
    }

    public static int subscriptionPartitionIdEncodingOffset() {
        return 0;
    }

    public static int subscriptionPartitionIdEncodingLength() {
        return 2;
    }

    public static String subscriptionPartitionIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int subscriptionPartitionIdNullValue() {
        return 65535;
    }

    public static int subscriptionPartitionIdMinValue() {
        return 0;
    }

    public static int subscriptionPartitionIdMaxValue() {
        return 65534;
    }

    public CorrelateWorkflowInstanceSubscriptionEncoder subscriptionPartitionId(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int workflowInstanceKeyId() {
        return 1;
    }

    public static int workflowInstanceKeySinceVersion() {
        return 0;
    }

    public static int workflowInstanceKeyEncodingOffset() {
        return 2;
    }

    public static int workflowInstanceKeyEncodingLength() {
        return 8;
    }

    public static String workflowInstanceKeyMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long workflowInstanceKeyNullValue() {
        return -1L;
    }

    public static long workflowInstanceKeyMinValue() {
        return 0L;
    }

    public static long workflowInstanceKeyMaxValue() {
        return -2L;
    }

    public CorrelateWorkflowInstanceSubscriptionEncoder workflowInstanceKey(long value) {
        this.buffer.putLong(this.offset + 2, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int elementInstanceKeyId() {
        return 2;
    }

    public static int elementInstanceKeySinceVersion() {
        return 0;
    }

    public static int elementInstanceKeyEncodingOffset() {
        return 10;
    }

    public static int elementInstanceKeyEncodingLength() {
        return 8;
    }

    public static String elementInstanceKeyMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long elementInstanceKeyNullValue() {
        return -1L;
    }

    public static long elementInstanceKeyMinValue() {
        return 0L;
    }

    public static long elementInstanceKeyMaxValue() {
        return -2L;
    }

    public CorrelateWorkflowInstanceSubscriptionEncoder elementInstanceKey(long value) {
        this.buffer.putLong(this.offset + 10, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int messageKeyId() {
        return 3;
    }

    public static int messageKeySinceVersion() {
        return 0;
    }

    public static int messageKeyEncodingOffset() {
        return 18;
    }

    public static int messageKeyEncodingLength() {
        return 8;
    }

    public static String messageKeyMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long messageKeyNullValue() {
        return -1L;
    }

    public static long messageKeyMinValue() {
        return 0L;
    }

    public static long messageKeyMaxValue() {
        return -2L;
    }

    public CorrelateWorkflowInstanceSubscriptionEncoder messageKey(long value) {
        this.buffer.putLong(this.offset + 18, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int messageNameId() {
        return 4;
    }

    public static String messageNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String messageNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int messageNameHeaderLength() {
        return 2;
    }

    public CorrelateWorkflowInstanceSubscriptionEncoder putMessageName(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public CorrelateWorkflowInstanceSubscriptionEncoder putMessageName(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public CorrelateWorkflowInstanceSubscriptionEncoder messageName(String value) {
        byte[] bytes;
        try {
            bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public static int variablesId() {
        return 5;
    }

    public static String variablesCharacterEncoding() {
        return "UTF-8";
    }

    public static String variablesMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int variablesHeaderLength() {
        return 2;
    }

    public CorrelateWorkflowInstanceSubscriptionEncoder putVariables(DirectBuffer src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public CorrelateWorkflowInstanceSubscriptionEncoder putVariables(byte[] src, int srcOffset, int length) {
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, src, srcOffset, length);
        return this;
    }

    public CorrelateWorkflowInstanceSubscriptionEncoder variables(String value) {
        byte[] bytes;
        try {
            bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int length = bytes.length;
        if (length > 65534) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 2 + length);
        this.buffer.putShort(limit, (short)length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 2, bytes, 0, length);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        CorrelateWorkflowInstanceSubscriptionDecoder writer = new CorrelateWorkflowInstanceSubscriptionDecoder();
        writer.wrap((DirectBuffer)this.buffer, this.offset, 26, 1);
        return writer.appendTo(builder);
    }
}

