/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message.command;

import io.zeebe.engine.processor.workflow.message.command.BooleanType;
import io.zeebe.engine.processor.workflow.message.command.OpenMessageSubscriptionDecoder;
import io.zeebe.engine.processor.workflow.message.command.OpenMessageSubscriptionEncoder;
import io.zeebe.engine.util.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class OpenMessageSubscriptionCommand
extends SbeBufferWriterReader<OpenMessageSubscriptionEncoder, OpenMessageSubscriptionDecoder> {
    private final OpenMessageSubscriptionEncoder encoder = new OpenMessageSubscriptionEncoder();
    private final OpenMessageSubscriptionDecoder decoder = new OpenMessageSubscriptionDecoder();
    private int subscriptionPartitionId;
    private long workflowInstanceKey;
    private long elementInstanceKey;
    private boolean closeOnCorrelate;
    private final UnsafeBuffer messageName = new UnsafeBuffer(0L, 0);
    private final UnsafeBuffer correlationKey = new UnsafeBuffer(0L, 0);

    @Override
    protected OpenMessageSubscriptionEncoder getBodyEncoder() {
        return this.encoder;
    }

    @Override
    protected OpenMessageSubscriptionDecoder getBodyDecoder() {
        return this.decoder;
    }

    @Override
    public int getLength() {
        return super.getLength() + OpenMessageSubscriptionDecoder.messageNameHeaderLength() + this.messageName.capacity() + OpenMessageSubscriptionDecoder.correlationKeyHeaderLength() + this.correlationKey.capacity();
    }

    @Override
    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.subscriptionPartitionId(this.subscriptionPartitionId).workflowInstanceKey(this.workflowInstanceKey).elementInstanceKey(this.elementInstanceKey).closeOnCorrelate(this.closeOnCorrelate ? BooleanType.TRUE : BooleanType.FALSE).putMessageName((DirectBuffer)this.messageName, 0, this.messageName.capacity()).putCorrelationKey((DirectBuffer)this.correlationKey, 0, this.correlationKey.capacity());
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.subscriptionPartitionId = this.decoder.subscriptionPartitionId();
        this.workflowInstanceKey = this.decoder.workflowInstanceKey();
        this.elementInstanceKey = this.decoder.elementInstanceKey();
        this.closeOnCorrelate = this.decoder.closeOnCorrelate() == BooleanType.TRUE;
        offset = this.decoder.limit();
        int messageNameLength = this.decoder.messageNameLength();
        this.messageName.wrap(buffer, offset += OpenMessageSubscriptionDecoder.messageNameHeaderLength(), messageNameLength);
        this.decoder.limit(offset += messageNameLength);
        int correlationKeyLength = this.decoder.correlationKeyLength();
        this.correlationKey.wrap(buffer, offset += OpenMessageSubscriptionDecoder.correlationKeyHeaderLength(), correlationKeyLength);
        this.decoder.limit(offset += correlationKeyLength);
    }

    @Override
    public void reset() {
        this.subscriptionPartitionId = OpenMessageSubscriptionDecoder.subscriptionPartitionIdNullValue();
        this.workflowInstanceKey = OpenMessageSubscriptionDecoder.workflowInstanceKeyNullValue();
        this.elementInstanceKey = OpenMessageSubscriptionDecoder.elementInstanceKeyNullValue();
        this.messageName.wrap(0L, 0);
        this.correlationKey.wrap(0L, 0);
    }

    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionId;
    }

    public void setSubscriptionPartitionId(int subscriptionPartitionId) {
        this.subscriptionPartitionId = subscriptionPartitionId;
    }

    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKey;
    }

    public void setWorkflowInstanceKey(long workflowInstanceKey) {
        this.workflowInstanceKey = workflowInstanceKey;
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public void setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public DirectBuffer getMessageName() {
        return this.messageName;
    }

    public DirectBuffer getCorrelationKey() {
        return this.correlationKey;
    }

    public boolean shouldCloseOnCorrelate() {
        return this.closeOnCorrelate;
    }

    public void setCloseOnCorrelate(boolean closeOnCorrelate) {
        this.closeOnCorrelate = closeOnCorrelate;
    }
}

