/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message.command;

import io.zeebe.engine.processor.workflow.message.command.BooleanType;
import io.zeebe.engine.processor.workflow.message.command.MetaAttribute;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public class OpenMessageSubscriptionDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 19;
    public static final int TEMPLATE_ID = 0;
    public static final int SCHEMA_ID = 6;
    public static final int SCHEMA_VERSION = 1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final OpenMessageSubscriptionDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength() {
        return 19;
    }

    public int sbeTemplateId() {
        return 0;
    }

    public int sbeSchemaId() {
        return 6;
    }

    public int sbeSchemaVersion() {
        return 1;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public OpenMessageSubscriptionDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int subscriptionPartitionIdId() {
        return 0;
    }

    public static int subscriptionPartitionIdSinceVersion() {
        return 0;
    }

    public static int subscriptionPartitionIdEncodingOffset() {
        return 0;
    }

    public static int subscriptionPartitionIdEncodingLength() {
        return 2;
    }

    public static String subscriptionPartitionIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int subscriptionPartitionIdNullValue() {
        return 65535;
    }

    public static int subscriptionPartitionIdMinValue() {
        return 0;
    }

    public static int subscriptionPartitionIdMaxValue() {
        return 65534;
    }

    public int subscriptionPartitionId() {
        return this.buffer.getShort(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int workflowInstanceKeyId() {
        return 1;
    }

    public static int workflowInstanceKeySinceVersion() {
        return 0;
    }

    public static int workflowInstanceKeyEncodingOffset() {
        return 2;
    }

    public static int workflowInstanceKeyEncodingLength() {
        return 8;
    }

    public static String workflowInstanceKeyMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long workflowInstanceKeyNullValue() {
        return -1L;
    }

    public static long workflowInstanceKeyMinValue() {
        return 0L;
    }

    public static long workflowInstanceKeyMaxValue() {
        return -2L;
    }

    public long workflowInstanceKey() {
        return this.buffer.getLong(this.offset + 2, ByteOrder.LITTLE_ENDIAN);
    }

    public static int elementInstanceKeyId() {
        return 2;
    }

    public static int elementInstanceKeySinceVersion() {
        return 0;
    }

    public static int elementInstanceKeyEncodingOffset() {
        return 10;
    }

    public static int elementInstanceKeyEncodingLength() {
        return 8;
    }

    public static String elementInstanceKeyMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long elementInstanceKeyNullValue() {
        return -1L;
    }

    public static long elementInstanceKeyMinValue() {
        return 0L;
    }

    public static long elementInstanceKeyMaxValue() {
        return -2L;
    }

    public long elementInstanceKey() {
        return this.buffer.getLong(this.offset + 10, ByteOrder.LITTLE_ENDIAN);
    }

    public static int closeOnCorrelateId() {
        return 3;
    }

    public static int closeOnCorrelateSinceVersion() {
        return 0;
    }

    public static int closeOnCorrelateEncodingOffset() {
        return 18;
    }

    public static int closeOnCorrelateEncodingLength() {
        return 1;
    }

    public static String closeOnCorrelateMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "";
            }
            case TIME_UNIT: {
                return "";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public BooleanType closeOnCorrelate() {
        return BooleanType.get((short)(this.buffer.getByte(this.offset + 18) & 0xFF));
    }

    public static int messageNameId() {
        return 4;
    }

    public static int messageNameSinceVersion() {
        return 0;
    }

    public static String messageNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String messageNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int messageNameHeaderLength() {
        return 2;
    }

    public int messageNameLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public int getMessageName(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getMessageName(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapMessageName(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String messageName() {
        String value;
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int correlationKeyId() {
        return 5;
    }

    public static int correlationKeySinceVersion() {
        return 0;
    }

    public static String correlationKeyCharacterEncoding() {
        return "UTF-8";
    }

    public static String correlationKeyMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static int correlationKeyHeaderLength() {
        return 2;
    }

    public int correlationKeyLength() {
        int limit = this.parentMessage.limit();
        return this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public int getCorrelationKey(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getCorrelationKey(byte[] dst, int dstOffset, int length) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 2 + dataLength);
        this.buffer.getBytes(limit + 2, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapCorrelationKey(DirectBuffer wrapBuffer) {
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 2, dataLength);
    }

    public String correlationKey() {
        String value;
        int headerLength = 2;
        int limit = this.parentMessage.limit();
        int dataLength = this.buffer.getShort(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
        this.parentMessage.limit(limit + 2 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 2, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[OpenMessageSubscription](sbeTemplateId=");
        builder.append(0);
        builder.append("|sbeSchemaId=");
        builder.append(6);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 1) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(1);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 19) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(19);
        builder.append("):");
        builder.append("subscriptionPartitionId=");
        builder.append(this.subscriptionPartitionId());
        builder.append('|');
        builder.append("workflowInstanceKey=");
        builder.append(this.workflowInstanceKey());
        builder.append('|');
        builder.append("elementInstanceKey=");
        builder.append(this.elementInstanceKey());
        builder.append('|');
        builder.append("closeOnCorrelate=");
        builder.append((Object)this.closeOnCorrelate());
        builder.append('|');
        builder.append("messageName=");
        builder.append('\'' + this.messageName() + '\'');
        builder.append('|');
        builder.append("correlationKey=");
        builder.append('\'' + this.correlationKey() + '\'');
        this.limit(originalLimit);
        return builder;
    }
}

