/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message.command;

import io.zeebe.engine.processor.workflow.message.command.BooleanType;
import io.zeebe.engine.processor.workflow.message.command.OpenWorkflowInstanceSubscriptionDecoder;
import io.zeebe.engine.processor.workflow.message.command.OpenWorkflowInstanceSubscriptionEncoder;
import io.zeebe.engine.util.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class OpenWorkflowInstanceSubscriptionCommand
extends SbeBufferWriterReader<OpenWorkflowInstanceSubscriptionEncoder, OpenWorkflowInstanceSubscriptionDecoder> {
    private final OpenWorkflowInstanceSubscriptionEncoder encoder = new OpenWorkflowInstanceSubscriptionEncoder();
    private final OpenWorkflowInstanceSubscriptionDecoder decoder = new OpenWorkflowInstanceSubscriptionDecoder();
    private int subscriptionPartitionId;
    private long workflowInstanceKey;
    private long elementInstanceKey;
    private boolean closeOnCorrelate;
    private final UnsafeBuffer messageName = new UnsafeBuffer(0L, 0);

    @Override
    protected OpenWorkflowInstanceSubscriptionEncoder getBodyEncoder() {
        return this.encoder;
    }

    @Override
    protected OpenWorkflowInstanceSubscriptionDecoder getBodyDecoder() {
        return this.decoder;
    }

    @Override
    public int getLength() {
        return super.getLength() + OpenWorkflowInstanceSubscriptionDecoder.messageNameHeaderLength() + this.messageName.capacity();
    }

    @Override
    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.subscriptionPartitionId(this.subscriptionPartitionId).workflowInstanceKey(this.workflowInstanceKey).elementInstanceKey(this.elementInstanceKey).closeOnCorrelate(this.closeOnCorrelate ? BooleanType.TRUE : BooleanType.FALSE).putMessageName((DirectBuffer)this.messageName, 0, this.messageName.capacity());
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.subscriptionPartitionId = this.decoder.subscriptionPartitionId();
        this.workflowInstanceKey = this.decoder.workflowInstanceKey();
        this.elementInstanceKey = this.decoder.elementInstanceKey();
        this.closeOnCorrelate = this.decoder.closeOnCorrelate() == BooleanType.TRUE;
        offset = this.decoder.limit();
        int messageNameLength = this.decoder.messageNameLength();
        this.messageName.wrap(buffer, offset += OpenWorkflowInstanceSubscriptionDecoder.messageNameHeaderLength(), messageNameLength);
    }

    @Override
    public void reset() {
        this.subscriptionPartitionId = OpenWorkflowInstanceSubscriptionDecoder.subscriptionPartitionIdNullValue();
        this.workflowInstanceKey = OpenWorkflowInstanceSubscriptionDecoder.workflowInstanceKeyNullValue();
        this.elementInstanceKey = OpenWorkflowInstanceSubscriptionDecoder.elementInstanceKeyNullValue();
        this.messageName.wrap(0L, 0);
    }

    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionId;
    }

    public void setSubscriptionPartitionId(int subscriptionPartitionId) {
        this.subscriptionPartitionId = subscriptionPartitionId;
    }

    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKey;
    }

    public void setWorkflowInstanceKey(long workflowInstanceKey) {
        this.workflowInstanceKey = workflowInstanceKey;
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public void setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public DirectBuffer getMessageName() {
        return this.messageName;
    }

    public boolean shouldCloseOnCorrelate() {
        return this.closeOnCorrelate;
    }

    public void setCloseOnCorrelate(boolean closeOnCorrelate) {
        this.closeOnCorrelate = closeOnCorrelate;
    }
}

