/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message.command;

import io.zeebe.engine.processor.workflow.message.command.RejectCorrelateMessageSubscriptionDecoder;
import io.zeebe.engine.processor.workflow.message.command.RejectCorrelateMessageSubscriptionEncoder;
import io.zeebe.engine.util.SbeBufferWriterReader;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class RejectCorrelateMessageSubscriptionCommand
extends SbeBufferWriterReader<RejectCorrelateMessageSubscriptionEncoder, RejectCorrelateMessageSubscriptionDecoder> {
    private final RejectCorrelateMessageSubscriptionEncoder encoder = new RejectCorrelateMessageSubscriptionEncoder();
    private final RejectCorrelateMessageSubscriptionDecoder decoder = new RejectCorrelateMessageSubscriptionDecoder();
    private int subscriptionPartitionId;
    private long workflowInstanceKey;
    private long messageKey;
    private final UnsafeBuffer messageName = new UnsafeBuffer(0L, 0);
    private final UnsafeBuffer correlationKey = new UnsafeBuffer(0L, 0);

    @Override
    protected RejectCorrelateMessageSubscriptionEncoder getBodyEncoder() {
        return this.encoder;
    }

    @Override
    protected RejectCorrelateMessageSubscriptionDecoder getBodyDecoder() {
        return this.decoder;
    }

    @Override
    public int getLength() {
        return super.getLength() + RejectCorrelateMessageSubscriptionDecoder.messageNameHeaderLength() + this.messageName.capacity() + RejectCorrelateMessageSubscriptionDecoder.correlationKeyHeaderLength() + this.correlationKey.capacity();
    }

    @Override
    public void write(MutableDirectBuffer buffer, int offset) {
        super.write(buffer, offset);
        this.encoder.subscriptionPartitionId(this.subscriptionPartitionId).workflowInstanceKey(this.workflowInstanceKey).messageKey(this.messageKey).putMessageName((DirectBuffer)this.messageName, 0, this.messageName.capacity()).putCorrelationKey((DirectBuffer)this.correlationKey, 0, this.correlationKey.capacity());
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        super.wrap(buffer, offset, length);
        this.subscriptionPartitionId = this.decoder.subscriptionPartitionId();
        this.workflowInstanceKey = this.decoder.workflowInstanceKey();
        this.messageKey = this.decoder.messageKey();
        this.decoder.wrapMessageName((DirectBuffer)this.messageName);
        this.decoder.wrapCorrelationKey((DirectBuffer)this.correlationKey);
    }

    @Override
    public void reset() {
        this.subscriptionPartitionId = RejectCorrelateMessageSubscriptionDecoder.subscriptionPartitionIdNullValue();
        this.workflowInstanceKey = RejectCorrelateMessageSubscriptionDecoder.workflowInstanceKeyNullValue();
        this.messageKey = RejectCorrelateMessageSubscriptionDecoder.messageKeyNullValue();
        this.messageName.wrap(0L, 0);
        this.correlationKey.wrap(0L, 0);
    }

    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionId;
    }

    public void setSubscriptionPartitionId(int subscriptionPartitionId) {
        this.subscriptionPartitionId = subscriptionPartitionId;
    }

    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKey;
    }

    public void setWorkflowInstanceKey(long workflowInstanceKey) {
        this.workflowInstanceKey = workflowInstanceKey;
    }

    public long getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(long messageKey) {
        this.messageKey = messageKey;
    }

    public DirectBuffer getMessageName() {
        return this.messageName;
    }

    public DirectBuffer getCorrelationKey() {
        return this.correlationKey;
    }
}

