/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message.command;

import io.zeebe.engine.processor.workflow.message.command.CloseMessageSubscriptionCommand;
import io.zeebe.engine.processor.workflow.message.command.CloseWorkflowInstanceSubscriptionCommand;
import io.zeebe.engine.processor.workflow.message.command.CorrelateMessageSubscriptionCommand;
import io.zeebe.engine.processor.workflow.message.command.CorrelateWorkflowInstanceSubscriptionCommand;
import io.zeebe.engine.processor.workflow.message.command.MessageHeaderDecoder;
import io.zeebe.engine.processor.workflow.message.command.OpenMessageSubscriptionCommand;
import io.zeebe.engine.processor.workflow.message.command.OpenWorkflowInstanceSubscriptionCommand;
import io.zeebe.engine.processor.workflow.message.command.RejectCorrelateMessageSubscriptionCommand;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamRecordWriter;
import io.zeebe.logstreams.log.LogStreamWriterImpl;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.Protocol;
import io.zeebe.protocol.impl.record.RecordMetadata;
import io.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.zeebe.protocol.impl.record.value.message.WorkflowInstanceSubscriptionRecord;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.zeebe.protocol.record.intent.WorkflowInstanceSubscriptionIntent;
import io.zeebe.util.buffer.BufferWriter;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class SubscriptionCommandMessageHandler
implements Function<byte[], CompletableFuture<Void>> {
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final OpenMessageSubscriptionCommand openMessageSubscriptionCommand = new OpenMessageSubscriptionCommand();
    private final OpenWorkflowInstanceSubscriptionCommand openWorkflowInstanceSubscriptionCommand = new OpenWorkflowInstanceSubscriptionCommand();
    private final CorrelateWorkflowInstanceSubscriptionCommand correlateWorkflowInstanceSubscriptionCommand = new CorrelateWorkflowInstanceSubscriptionCommand();
    private final CorrelateMessageSubscriptionCommand correlateMessageSubscriptionCommand = new CorrelateMessageSubscriptionCommand();
    private final CloseMessageSubscriptionCommand closeMessageSubscriptionCommand = new CloseMessageSubscriptionCommand();
    private final CloseWorkflowInstanceSubscriptionCommand closeWorkflowInstanceSubscriptionCommand = new CloseWorkflowInstanceSubscriptionCommand();
    private final RejectCorrelateMessageSubscriptionCommand resetMessageCorrelationCommand = new RejectCorrelateMessageSubscriptionCommand();
    private final LogStreamRecordWriter logStreamWriter = new LogStreamWriterImpl();
    private final RecordMetadata recordMetadata = new RecordMetadata();
    private final MessageSubscriptionRecord messageSubscriptionRecord = new MessageSubscriptionRecord();
    private final WorkflowInstanceSubscriptionRecord workflowInstanceSubscriptionRecord = new WorkflowInstanceSubscriptionRecord();
    private final Consumer<Runnable> enviromentToRun;
    private final Function<Integer, LogStream> logstreamSupplier;

    public SubscriptionCommandMessageHandler(Consumer<Runnable> enviromentToRun, Function<Integer, LogStream> logstreamSupplier) {
        this.enviromentToRun = enviromentToRun;
        this.logstreamSupplier = logstreamSupplier;
    }

    @Override
    public CompletableFuture<Void> apply(byte[] bytes) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.enviromentToRun.accept(() -> {
            UnsafeBuffer buffer = new UnsafeBuffer(bytes);
            boolean offset = false;
            int length = buffer.capacity();
            this.messageHeaderDecoder.wrap((DirectBuffer)buffer, 0);
            if (this.messageHeaderDecoder.schemaId() == 6) {
                switch (this.messageHeaderDecoder.templateId()) {
                    case 0: {
                        this.onOpenMessageSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                    case 1: {
                        this.onOpenWorkflowInstanceSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                    case 2: {
                        this.onCorrelateWorkflowInstanceSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                    case 3: {
                        this.onCorrelateMessageSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                    case 4: {
                        this.onCloseMessageSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                    case 5: {
                        this.onCloseWorkflowInstanceSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                    case 6: {
                        this.onRejectCorrelateMessageSubscription((DirectBuffer)buffer, 0, length);
                        break;
                    }
                }
            }
            future.complete(null);
        });
        return future;
    }

    private boolean onOpenMessageSubscription(DirectBuffer buffer, int offset, int length) {
        this.openMessageSubscriptionCommand.wrap(buffer, offset, length);
        this.messageSubscriptionRecord.setWorkflowInstanceKey(this.openMessageSubscriptionCommand.getWorkflowInstanceKey()).setElementInstanceKey(this.openMessageSubscriptionCommand.getElementInstanceKey()).setMessageKey(-1L).setMessageName(this.openMessageSubscriptionCommand.getMessageName()).setCorrelationKey(this.openMessageSubscriptionCommand.getCorrelationKey()).setCloseOnCorrelate(this.openMessageSubscriptionCommand.shouldCloseOnCorrelate());
        return this.writeCommand(this.openMessageSubscriptionCommand.getSubscriptionPartitionId(), ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.OPEN, (UnpackedObject)this.messageSubscriptionRecord);
    }

    private boolean onOpenWorkflowInstanceSubscription(DirectBuffer buffer, int offset, int length) {
        this.openWorkflowInstanceSubscriptionCommand.wrap(buffer, offset, length);
        long workflowInstanceKey = this.openWorkflowInstanceSubscriptionCommand.getWorkflowInstanceKey();
        int workflowInstancePartitionId = Protocol.decodePartitionId((long)workflowInstanceKey);
        this.workflowInstanceSubscriptionRecord.reset();
        this.workflowInstanceSubscriptionRecord.setSubscriptionPartitionId(this.openWorkflowInstanceSubscriptionCommand.getSubscriptionPartitionId()).setWorkflowInstanceKey(workflowInstanceKey).setElementInstanceKey(this.openWorkflowInstanceSubscriptionCommand.getElementInstanceKey()).setMessageKey(-1L).setMessageName(this.openWorkflowInstanceSubscriptionCommand.getMessageName()).setCloseOnCorrelate(this.openWorkflowInstanceSubscriptionCommand.shouldCloseOnCorrelate());
        return this.writeCommand(workflowInstancePartitionId, ValueType.WORKFLOW_INSTANCE_SUBSCRIPTION, (Intent)WorkflowInstanceSubscriptionIntent.OPEN, (UnpackedObject)this.workflowInstanceSubscriptionRecord);
    }

    private boolean onCorrelateWorkflowInstanceSubscription(DirectBuffer buffer, int offset, int length) {
        this.correlateWorkflowInstanceSubscriptionCommand.wrap(buffer, offset, length);
        long workflowInstanceKey = this.correlateWorkflowInstanceSubscriptionCommand.getWorkflowInstanceKey();
        int workflowInstancePartitionId = Protocol.decodePartitionId((long)workflowInstanceKey);
        this.workflowInstanceSubscriptionRecord.setSubscriptionPartitionId(this.correlateWorkflowInstanceSubscriptionCommand.getSubscriptionPartitionId()).setWorkflowInstanceKey(workflowInstanceKey).setElementInstanceKey(this.correlateWorkflowInstanceSubscriptionCommand.getElementInstanceKey()).setMessageKey(this.correlateWorkflowInstanceSubscriptionCommand.getMessageKey()).setMessageName(this.correlateWorkflowInstanceSubscriptionCommand.getMessageName()).setVariables(this.correlateWorkflowInstanceSubscriptionCommand.getVariables());
        return this.writeCommand(workflowInstancePartitionId, ValueType.WORKFLOW_INSTANCE_SUBSCRIPTION, (Intent)WorkflowInstanceSubscriptionIntent.CORRELATE, (UnpackedObject)this.workflowInstanceSubscriptionRecord);
    }

    private boolean onCorrelateMessageSubscription(DirectBuffer buffer, int offset, int length) {
        this.correlateMessageSubscriptionCommand.wrap(buffer, offset, length);
        this.messageSubscriptionRecord.reset();
        this.messageSubscriptionRecord.setWorkflowInstanceKey(this.correlateMessageSubscriptionCommand.getWorkflowInstanceKey()).setElementInstanceKey(this.correlateMessageSubscriptionCommand.getElementInstanceKey()).setMessageKey(-1L).setMessageName(this.correlateMessageSubscriptionCommand.getMessageName());
        return this.writeCommand(this.correlateMessageSubscriptionCommand.getSubscriptionPartitionId(), ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CORRELATE, (UnpackedObject)this.messageSubscriptionRecord);
    }

    private boolean onCloseMessageSubscription(DirectBuffer buffer, int offset, int length) {
        this.closeMessageSubscriptionCommand.wrap(buffer, offset, length);
        this.messageSubscriptionRecord.reset();
        this.messageSubscriptionRecord.setWorkflowInstanceKey(this.closeMessageSubscriptionCommand.getWorkflowInstanceKey()).setElementInstanceKey(this.closeMessageSubscriptionCommand.getElementInstanceKey()).setMessageKey(-1L).setMessageName(this.closeMessageSubscriptionCommand.getMessageName());
        return this.writeCommand(this.closeMessageSubscriptionCommand.getSubscriptionPartitionId(), ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.CLOSE, (UnpackedObject)this.messageSubscriptionRecord);
    }

    private boolean onCloseWorkflowInstanceSubscription(DirectBuffer buffer, int offset, int length) {
        this.closeWorkflowInstanceSubscriptionCommand.wrap(buffer, offset, length);
        long workflowInstanceKey = this.closeWorkflowInstanceSubscriptionCommand.getWorkflowInstanceKey();
        int workflowInstancePartitionId = Protocol.decodePartitionId((long)workflowInstanceKey);
        this.workflowInstanceSubscriptionRecord.reset();
        this.workflowInstanceSubscriptionRecord.setSubscriptionPartitionId(this.closeWorkflowInstanceSubscriptionCommand.getSubscriptionPartitionId()).setWorkflowInstanceKey(workflowInstanceKey).setElementInstanceKey(this.closeWorkflowInstanceSubscriptionCommand.getElementInstanceKey()).setMessageKey(-1L).setMessageName(this.closeWorkflowInstanceSubscriptionCommand.getMessageName());
        return this.writeCommand(workflowInstancePartitionId, ValueType.WORKFLOW_INSTANCE_SUBSCRIPTION, (Intent)WorkflowInstanceSubscriptionIntent.CLOSE, (UnpackedObject)this.workflowInstanceSubscriptionRecord);
    }

    private boolean onRejectCorrelateMessageSubscription(DirectBuffer buffer, int offset, int length) {
        this.resetMessageCorrelationCommand.wrap(buffer, offset, length);
        long workflowInstanceKey = this.resetMessageCorrelationCommand.getWorkflowInstanceKey();
        this.messageSubscriptionRecord.reset();
        this.messageSubscriptionRecord.setWorkflowInstanceKey(workflowInstanceKey).setElementInstanceKey(-1L).setMessageName(this.resetMessageCorrelationCommand.getMessageName()).setCorrelationKey(this.resetMessageCorrelationCommand.getCorrelationKey()).setMessageKey(this.resetMessageCorrelationCommand.getMessageKey()).setCloseOnCorrelate(false);
        return this.writeCommand(this.resetMessageCorrelationCommand.getSubscriptionPartitionId(), ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.REJECT, (UnpackedObject)this.messageSubscriptionRecord);
    }

    private boolean writeCommand(int partitionId, ValueType valueType, Intent intent, UnpackedObject command) {
        LogStream logStream = this.logstreamSupplier.apply(partitionId);
        if (logStream == null) {
            return true;
        }
        this.logStreamWriter.wrap(logStream);
        this.recordMetadata.reset().partitionId(partitionId).recordType(RecordType.COMMAND).valueType(valueType).intent(intent);
        long position = this.logStreamWriter.key(-1L).metadataWriter((BufferWriter)this.recordMetadata).valueWriter((BufferWriter)command).tryWrite();
        return position > 0L;
    }
}

