/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.message.command;

import io.zeebe.engine.processor.workflow.message.command.CloseMessageSubscriptionCommand;
import io.zeebe.engine.processor.workflow.message.command.CloseWorkflowInstanceSubscriptionCommand;
import io.zeebe.engine.processor.workflow.message.command.CorrelateMessageSubscriptionCommand;
import io.zeebe.engine.processor.workflow.message.command.CorrelateWorkflowInstanceSubscriptionCommand;
import io.zeebe.engine.processor.workflow.message.command.OpenMessageSubscriptionCommand;
import io.zeebe.engine.processor.workflow.message.command.OpenWorkflowInstanceSubscriptionCommand;
import io.zeebe.engine.processor.workflow.message.command.PartitionCommandSender;
import io.zeebe.engine.processor.workflow.message.command.RejectCorrelateMessageSubscriptionCommand;
import io.zeebe.protocol.Protocol;
import org.agrona.DirectBuffer;

public class SubscriptionCommandSender {
    private final OpenMessageSubscriptionCommand openMessageSubscriptionCommand = new OpenMessageSubscriptionCommand();
    private final OpenWorkflowInstanceSubscriptionCommand openWorkflowInstanceSubscriptionCommand = new OpenWorkflowInstanceSubscriptionCommand();
    private final CorrelateWorkflowInstanceSubscriptionCommand correlateWorkflowInstanceSubscriptionCommand = new CorrelateWorkflowInstanceSubscriptionCommand();
    private final CorrelateMessageSubscriptionCommand correlateMessageSubscriptionCommand = new CorrelateMessageSubscriptionCommand();
    private final CloseMessageSubscriptionCommand closeMessageSubscriptionCommand = new CloseMessageSubscriptionCommand();
    private final CloseWorkflowInstanceSubscriptionCommand closeWorkflowInstanceSubscriptionCommand = new CloseWorkflowInstanceSubscriptionCommand();
    private final RejectCorrelateMessageSubscriptionCommand rejectCorrelateMessageSubscriptionCommand = new RejectCorrelateMessageSubscriptionCommand();
    private final PartitionCommandSender partitionCommandSender;
    private final int senderPartition;

    public SubscriptionCommandSender(int senderPartition, PartitionCommandSender partitionCommandSender) {
        this.senderPartition = senderPartition;
        this.partitionCommandSender = partitionCommandSender;
    }

    public boolean openMessageSubscription(int subscriptionPartitionId, long workflowInstanceKey, long elementInstanceKey, DirectBuffer messageName, DirectBuffer correlationKey, boolean closeOnCorrelate) {
        this.openMessageSubscriptionCommand.setSubscriptionPartitionId(subscriptionPartitionId);
        this.openMessageSubscriptionCommand.setWorkflowInstanceKey(workflowInstanceKey);
        this.openMessageSubscriptionCommand.setElementInstanceKey(elementInstanceKey);
        this.openMessageSubscriptionCommand.getMessageName().wrap(messageName);
        this.openMessageSubscriptionCommand.getCorrelationKey().wrap(correlationKey);
        this.openMessageSubscriptionCommand.setCloseOnCorrelate(closeOnCorrelate);
        return this.partitionCommandSender.sendCommand(subscriptionPartitionId, this.openMessageSubscriptionCommand);
    }

    public boolean openWorkflowInstanceSubscription(long workflowInstanceKey, long elementInstanceKey, DirectBuffer messageName, boolean closeOnCorrelate) {
        int workflowInstancePartitionId = Protocol.decodePartitionId((long)workflowInstanceKey);
        this.openWorkflowInstanceSubscriptionCommand.setSubscriptionPartitionId(this.senderPartition);
        this.openWorkflowInstanceSubscriptionCommand.setWorkflowInstanceKey(workflowInstanceKey);
        this.openWorkflowInstanceSubscriptionCommand.setElementInstanceKey(elementInstanceKey);
        this.openWorkflowInstanceSubscriptionCommand.getMessageName().wrap(messageName);
        this.openWorkflowInstanceSubscriptionCommand.setCloseOnCorrelate(closeOnCorrelate);
        return this.partitionCommandSender.sendCommand(workflowInstancePartitionId, this.openWorkflowInstanceSubscriptionCommand);
    }

    public boolean correlateWorkflowInstanceSubscription(long workflowInstanceKey, long elementInstanceKey, DirectBuffer messageName, long messageKey, DirectBuffer variables) {
        int workflowInstancePartitionId = Protocol.decodePartitionId((long)workflowInstanceKey);
        this.correlateWorkflowInstanceSubscriptionCommand.setSubscriptionPartitionId(this.senderPartition);
        this.correlateWorkflowInstanceSubscriptionCommand.setWorkflowInstanceKey(workflowInstanceKey);
        this.correlateWorkflowInstanceSubscriptionCommand.setElementInstanceKey(elementInstanceKey);
        this.correlateWorkflowInstanceSubscriptionCommand.setMessageKey(messageKey);
        this.correlateWorkflowInstanceSubscriptionCommand.getMessageName().wrap(messageName);
        this.correlateWorkflowInstanceSubscriptionCommand.getVariables().wrap(variables);
        return this.partitionCommandSender.sendCommand(workflowInstancePartitionId, this.correlateWorkflowInstanceSubscriptionCommand);
    }

    public boolean correlateMessageSubscription(int subscriptionPartitionId, long workflowInstanceKey, long elementInstanceKey, DirectBuffer messageName) {
        this.correlateMessageSubscriptionCommand.setSubscriptionPartitionId(subscriptionPartitionId);
        this.correlateMessageSubscriptionCommand.setWorkflowInstanceKey(workflowInstanceKey);
        this.correlateMessageSubscriptionCommand.setElementInstanceKey(elementInstanceKey);
        this.correlateMessageSubscriptionCommand.getMessageName().wrap(messageName);
        return this.partitionCommandSender.sendCommand(subscriptionPartitionId, this.correlateMessageSubscriptionCommand);
    }

    public boolean closeMessageSubscription(int subscriptionPartitionId, long workflowInstanceKey, long elementInstanceKey, DirectBuffer messageName) {
        this.closeMessageSubscriptionCommand.setSubscriptionPartitionId(subscriptionPartitionId);
        this.closeMessageSubscriptionCommand.setWorkflowInstanceKey(workflowInstanceKey);
        this.closeMessageSubscriptionCommand.setElementInstanceKey(elementInstanceKey);
        this.closeMessageSubscriptionCommand.setMessageName(messageName);
        return this.partitionCommandSender.sendCommand(subscriptionPartitionId, this.closeMessageSubscriptionCommand);
    }

    public boolean closeWorkflowInstanceSubscription(long workflowInstanceKey, long elementInstanceKey, DirectBuffer messageName) {
        int workflowInstancePartitionId = Protocol.decodePartitionId((long)workflowInstanceKey);
        this.closeWorkflowInstanceSubscriptionCommand.setSubscriptionPartitionId(this.senderPartition);
        this.closeWorkflowInstanceSubscriptionCommand.setWorkflowInstanceKey(workflowInstanceKey);
        this.closeWorkflowInstanceSubscriptionCommand.setElementInstanceKey(elementInstanceKey);
        this.closeWorkflowInstanceSubscriptionCommand.setMessageName(messageName);
        return this.partitionCommandSender.sendCommand(workflowInstancePartitionId, this.closeWorkflowInstanceSubscriptionCommand);
    }

    public boolean rejectCorrelateMessageSubscription(long workflowInstanceKey, long elementInstanceKey, long messageKey, DirectBuffer messageName, DirectBuffer correlationKey) {
        int workflowInstancePartitionId = Protocol.decodePartitionId((long)workflowInstanceKey);
        this.rejectCorrelateMessageSubscriptionCommand.setSubscriptionPartitionId(this.senderPartition);
        this.rejectCorrelateMessageSubscriptionCommand.setWorkflowInstanceKey(workflowInstanceKey);
        this.rejectCorrelateMessageSubscriptionCommand.setMessageKey(messageKey);
        this.rejectCorrelateMessageSubscriptionCommand.getMessageName().wrap(messageName);
        this.rejectCorrelateMessageSubscriptionCommand.getCorrelationKey().wrap(correlationKey);
        return this.partitionCommandSender.sendCommand(workflowInstancePartitionId, this.rejectCorrelateMessageSubscriptionCommand);
    }
}

