/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.timer;

import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.engine.state.instance.TimerInstance;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.TimerIntent;

public class CancelTimerProcessor
implements TypedRecordProcessor<TimerRecord> {
    public static final String NO_TIMER_FOUND_MESSAGE = "Expected to cancel timer with key '%d', but no such timer was found";
    private final WorkflowState workflowState;

    public CancelTimerProcessor(WorkflowState workflowState) {
        this.workflowState = workflowState;
    }

    @Override
    public void processRecord(TypedRecord<TimerRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        TimerRecord timer = record.getValue();
        TimerInstance timerInstance = this.workflowState.getTimerState().get(timer.getElementInstanceKey(), record.getKey());
        if (timerInstance == null) {
            streamWriter.appendRejection(record, RejectionType.NOT_FOUND, String.format(NO_TIMER_FOUND_MESSAGE, record.getKey()));
        } else {
            streamWriter.appendFollowUpEvent(record.getKey(), (Intent)TimerIntent.CANCELED, (UnpackedObject)timer);
            this.workflowState.getTimerState().remove(timerInstance);
        }
    }
}

