/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.timer;

import io.zeebe.engine.processor.KeyGenerator;
import io.zeebe.engine.processor.SideEffectProducer;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.processor.workflow.timer.DueDateTimerChecker;
import io.zeebe.engine.state.ZeebeState;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.engine.state.instance.TimerInstance;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.TimerIntent;
import java.util.function.Consumer;

public class CreateTimerProcessor
implements TypedRecordProcessor<TimerRecord> {
    private final DueDateTimerChecker timerChecker;
    private final WorkflowState workflowState;
    private final TimerInstance timerInstance = new TimerInstance();
    private final KeyGenerator keyGenerator;

    public CreateTimerProcessor(ZeebeState zeebeState, DueDateTimerChecker timerChecker) {
        this.timerChecker = timerChecker;
        this.workflowState = zeebeState.getWorkflowState();
        this.keyGenerator = zeebeState.getKeyGenerator();
    }

    @Override
    public void processRecord(TypedRecord<TimerRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter, Consumer<SideEffectProducer> sideEffect) {
        TimerRecord timer = record.getValue();
        long timerKey = this.keyGenerator.nextKey();
        this.timerInstance.setElementInstanceKey(timer.getElementInstanceKey());
        this.timerInstance.setDueDate(timer.getDueDate());
        this.timerInstance.setKey(timerKey);
        this.timerInstance.setHandlerNodeId(timer.getHandlerNodeId());
        this.timerInstance.setRepetitions(timer.getRepetitions());
        this.timerInstance.setWorkflowKey(timer.getWorkflowKey());
        this.timerInstance.setWorkflowInstanceKey(timer.getWorkflowInstanceKey());
        sideEffect.accept(this::scheduleTimer);
        streamWriter.appendFollowUpEvent(timerKey, (Intent)TimerIntent.CREATED, (UnpackedObject)timer);
        this.workflowState.getTimerState().put(this.timerInstance);
    }

    private boolean scheduleTimer() {
        this.timerChecker.scheduleTimer(this.timerInstance);
        return true;
    }
}

