/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.timer;

import io.zeebe.engine.processor.ReadonlyProcessingContext;
import io.zeebe.engine.processor.StreamProcessorLifecycleAware;
import io.zeebe.engine.processor.TypedStreamWriterImpl;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.engine.state.instance.TimerInstance;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.TimerIntent;
import io.zeebe.util.sched.ActorControl;
import io.zeebe.util.sched.ScheduledTimer;
import io.zeebe.util.sched.clock.ActorClock;
import java.time.Duration;

public class DueDateTimerChecker
implements StreamProcessorLifecycleAware {
    private static final long TIMER_RESOLUTION = Duration.ofMillis(100L).toMillis();
    private final TimerRecord timerRecord = new TimerRecord();
    private final WorkflowState workflowState;
    private ActorControl actor;
    private TypedStreamWriterImpl streamWriter;
    private ScheduledTimer scheduledTimer;
    private long nextDueDate = -1L;

    public DueDateTimerChecker(WorkflowState workflowState) {
        this.workflowState = workflowState;
    }

    public void scheduleTimer(TimerInstance timer) {
        Duration duration = Duration.ofMillis(timer.getDueDate() - ActorClock.currentTimeMillis());
        if (this.scheduledTimer == null) {
            this.scheduledTimer = this.actor.runDelayed(duration, this::triggerTimers);
            this.nextDueDate = timer.getDueDate();
        } else if (this.nextDueDate - timer.getDueDate() > TIMER_RESOLUTION) {
            this.scheduledTimer.cancel();
            this.scheduledTimer = this.actor.runDelayed(duration, this::triggerTimers);
            this.nextDueDate = timer.getDueDate();
        }
    }

    private void triggerTimers() {
        this.nextDueDate = this.workflowState.getTimerState().findTimersWithDueDateBefore(ActorClock.currentTimeMillis(), this::triggerTimer);
        if (this.nextDueDate > 0L) {
            Duration duration = Duration.ofMillis(this.nextDueDate - ActorClock.currentTimeMillis());
            this.scheduledTimer = this.actor.runDelayed(duration, this::triggerTimers);
        } else {
            this.scheduledTimer = null;
        }
    }

    private boolean triggerTimer(TimerInstance timer) {
        this.timerRecord.reset();
        this.timerRecord.setElementInstanceKey(timer.getElementInstanceKey()).setWorkflowInstanceKey(timer.getWorkflowInstanceKey()).setDueDate(timer.getDueDate()).setHandlerNodeId(timer.getHandlerNodeId()).setRepetitions(timer.getRepetitions()).setWorkflowKey(timer.getWorkflowKey());
        this.streamWriter.appendFollowUpCommand(timer.getKey(), (Intent)TimerIntent.TRIGGER, (UnpackedObject)this.timerRecord);
        return this.streamWriter.flush() > 0L;
    }

    @Override
    public void onOpen(ReadonlyProcessingContext processingContext) {
        this.actor = processingContext.getActor();
        this.streamWriter = new TypedStreamWriterImpl(processingContext.getLogStream());
    }

    @Override
    public void onRecovered(ReadonlyProcessingContext processingContext) {
        this.triggerTimers();
    }
}

