/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.timer;

import io.zeebe.engine.processor.KeyGenerator;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.processor.TypedRecordProcessor;
import io.zeebe.engine.processor.TypedResponseWriter;
import io.zeebe.engine.processor.TypedStreamWriter;
import io.zeebe.engine.processor.workflow.CatchEventBehavior;
import io.zeebe.engine.processor.workflow.deployment.model.element.AbstractFlowElement;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableCatchEventElement;
import io.zeebe.engine.state.ZeebeState;
import io.zeebe.engine.state.deployment.DeployedWorkflow;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.instance.TimerInstance;
import io.zeebe.model.bpmn.util.time.RepeatingInterval;
import io.zeebe.model.bpmn.util.time.Timer;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.msgpack.value.DocumentValue;
import io.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.TimerIntent;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.protocol.record.value.BpmnElementType;
import io.zeebe.util.buffer.BufferUtil;
import java.util.List;
import org.agrona.DirectBuffer;

public class TriggerTimerProcessor
implements TypedRecordProcessor<TimerRecord> {
    private static final String NO_TIMER_FOUND_MESSAGE = "Expected to trigger timer with key '%d', but no such timer was found";
    private static final String NO_ACTIVE_TIMER_MESSAGE = "Expected to trigger a timer with key '%d', but the timer is not active anymore";
    private final CatchEventBehavior catchEventBehavior;
    private final WorkflowState workflowState;
    private final WorkflowInstanceRecord eventOccurredRecord = new WorkflowInstanceRecord();
    private final KeyGenerator keyGenerator;

    public TriggerTimerProcessor(ZeebeState zeebeState, CatchEventBehavior catchEventBehavior) {
        this.workflowState = zeebeState.getWorkflowState();
        this.keyGenerator = zeebeState.getKeyGenerator();
        this.catchEventBehavior = catchEventBehavior;
    }

    @Override
    public void processRecord(TypedRecord<TimerRecord> record, TypedResponseWriter responseWriter, TypedStreamWriter streamWriter) {
        TimerRecord timer = record.getValue();
        long elementInstanceKey = timer.getElementInstanceKey();
        TimerInstance timerInstance = this.workflowState.getTimerState().get(elementInstanceKey, record.getKey());
        if (timerInstance == null) {
            streamWriter.appendRejection(record, RejectionType.NOT_FOUND, String.format(NO_TIMER_FOUND_MESSAGE, record.getKey()));
            return;
        }
        this.workflowState.getTimerState().remove(timerInstance);
        this.processTimerTrigger(record, streamWriter, timer, elementInstanceKey);
    }

    private void processTimerTrigger(TypedRecord<TimerRecord> record, TypedStreamWriter streamWriter, TimerRecord timer, long elementInstanceKey) {
        long eventScopeKey = this.isTimerStartEvent(elementInstanceKey) ? record.getValue().getWorkflowKey() : elementInstanceKey;
        boolean wasActiveTimer = this.tryTriggerTimer(eventScopeKey, streamWriter, timer);
        if (wasActiveTimer) {
            ExecutableCatchEventElement timerEvent;
            long eventOccurredKey = this.prepareEventOccurredEvent(streamWriter, timer, elementInstanceKey);
            streamWriter.appendFollowUpEvent(record.getKey(), (Intent)TimerIntent.TRIGGERED, (UnpackedObject)timer);
            streamWriter.appendFollowUpEvent(eventOccurredKey, (Intent)WorkflowInstanceIntent.EVENT_OCCURRED, (UnpackedObject)this.eventOccurredRecord);
            if (this.shouldReschedule(timer) && (timerEvent = this.getTimerEvent(elementInstanceKey, timer)) != null && timerEvent.isTimer()) {
                this.rescheduleTimer(timer, streamWriter, timerEvent);
            }
        } else {
            streamWriter.appendRejection(record, RejectionType.INVALID_STATE, String.format(NO_ACTIVE_TIMER_MESSAGE, record.getKey()));
        }
    }

    private boolean tryTriggerTimer(long eventScopeKey, TypedStreamWriter streamWriter, TimerRecord timer) {
        long eventKey = this.keyGenerator.nextKey();
        return this.workflowState.getEventScopeInstanceState().triggerEvent(eventScopeKey, eventKey, timer.getHandlerNodeId(), DocumentValue.EMPTY_DOCUMENT);
    }

    private long prepareEventOccurredEvent(TypedStreamWriter streamWriter, TimerRecord timer, long elementInstanceKey) {
        long eventOccurredKey;
        this.eventOccurredRecord.reset();
        if (this.isTimerStartEvent(elementInstanceKey)) {
            eventOccurredKey = this.keyGenerator.nextKey();
            this.eventOccurredRecord.setBpmnElementType(BpmnElementType.START_EVENT).setWorkflowKey(timer.getWorkflowKey()).setElementId(timer.getHandlerNodeId());
        } else {
            eventOccurredKey = elementInstanceKey;
            this.eventOccurredRecord.wrap(this.workflowState.getElementInstanceState().getInstance(elementInstanceKey).getValue());
        }
        return eventOccurredKey;
    }

    private boolean isTimerStartEvent(long elementInstanceKey) {
        return elementInstanceKey == -1L;
    }

    private boolean shouldReschedule(TimerRecord timer) {
        return timer.getRepetitions() == -1 || timer.getRepetitions() > 1;
    }

    private ExecutableCatchEventElement getTimerEvent(long elementInstanceKey, TimerRecord timer) {
        if (this.isTimerStartEvent(elementInstanceKey)) {
            List<ExecutableCatchEventElement> startEvents = this.workflowState.getWorkflowByKey(timer.getWorkflowKey()).getWorkflow().getStartEvents();
            for (ExecutableCatchEventElement startEvent : startEvents) {
                if (!startEvent.getId().equals(timer.getHandlerNodeId())) continue;
                return startEvent;
            }
        } else {
            ElementInstance elementInstance = this.workflowState.getElementInstanceState().getInstance(elementInstanceKey);
            if (elementInstance != null) {
                return this.getCatchEventById(this.workflowState, elementInstance.getValue().getWorkflowKey(), timer.getHandlerNodeId());
            }
        }
        return null;
    }

    private void rescheduleTimer(TimerRecord record, TypedStreamWriter writer, ExecutableCatchEventElement event) {
        if (event.getTimer() == null) {
            String message = String.format("Expected to reschedule repeating timer for element with id '%s', but no timer definition was found", BufferUtil.bufferAsString((DirectBuffer)event.getId()));
            throw new IllegalStateException(message);
        }
        int repetitions = record.getRepetitions();
        if (repetitions != -1) {
            --repetitions;
        }
        RepeatingInterval timer = new RepeatingInterval(repetitions, event.getTimer().getInterval());
        this.catchEventBehavior.subscribeToTimerEvent(record.getElementInstanceKey(), record.getWorkflowInstanceKey(), record.getWorkflowKey(), event.getId(), (Timer)timer, writer);
    }

    private ExecutableCatchEventElement getCatchEventById(WorkflowState state, long workflowKey, DirectBuffer id) {
        DeployedWorkflow workflow = state.getWorkflowByKey(workflowKey);
        if (workflow == null) {
            throw new IllegalStateException(String.format("Expected to reschedule timer in workflow with key '%d', but no such workflow was found", workflowKey));
        }
        AbstractFlowElement element = workflow.getWorkflow().getElementById(id);
        if (element == null) {
            throw new IllegalStateException(String.format("Expected to reschedule timer for element with id '%s', but no such element was found", BufferUtil.bufferAsString((DirectBuffer)id)));
        }
        if (!(element instanceof ExecutableCatchEventElement)) {
            throw new IllegalStateException(String.format("Expected to reschedule timer for element with id '%s', but the element is not a timer catch event", workflowKey));
        }
        return (ExecutableCatchEventElement)element;
    }
}

