/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.processor.workflow.variable;

import io.zeebe.engine.Loggers;
import io.zeebe.engine.processor.CommandProcessor;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.instance.ElementInstanceState;
import io.zeebe.engine.state.instance.VariablesState;
import io.zeebe.msgpack.spec.MsgpackReaderException;
import io.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.zeebe.protocol.record.value.VariableDocumentUpdateSemantic;
import org.agrona.DirectBuffer;

public class UpdateVariableDocumentProcessor
implements CommandProcessor<VariableDocumentRecord> {
    private final ElementInstanceState elementInstanceState;
    private final VariablesState variablesState;

    public UpdateVariableDocumentProcessor(ElementInstanceState elementInstanceState, VariablesState variablesState) {
        this.elementInstanceState = elementInstanceState;
        this.variablesState = variablesState;
    }

    @Override
    public void onCommand(TypedRecord<VariableDocumentRecord> command, CommandProcessor.CommandControl<VariableDocumentRecord> controller) {
        VariableDocumentRecord record = command.getValue();
        ElementInstance scope = this.elementInstanceState.getInstance(record.getScopeKey());
        if (scope == null) {
            controller.reject(RejectionType.NOT_FOUND, String.format("Expected to update variables for element with key '%d', but no such element was found", record.getScopeKey()));
            return;
        }
        long workflowKey = scope.getValue().getWorkflowKey();
        if (this.mergeDocument(record, workflowKey, controller)) {
            controller.accept((Intent)VariableDocumentIntent.UPDATED, record);
        }
    }

    private boolean mergeDocument(VariableDocumentRecord record, long workflowKey, CommandProcessor.CommandControl<VariableDocumentRecord> controller) {
        try {
            this.getUpdateOperation(record.getUpdateSemantics()).apply(record.getScopeKey(), workflowKey, record.getDocumentBuffer());
            return true;
        }
        catch (MsgpackReaderException e) {
            Loggers.WORKFLOW_PROCESSOR_LOGGER.error("Expected to merge variable document for scope '{}', but its document could not be read", (Object)record.getScopeKey(), (Object)e);
            controller.reject(RejectionType.INVALID_ARGUMENT, String.format("Expected document to be valid msgpack, but it could not be read: '%s'", e.getMessage()));
            return false;
        }
    }

    private UpdateOperation getUpdateOperation(VariableDocumentUpdateSemantic updateSemantics) {
        switch (updateSemantics) {
            case LOCAL: {
                return this.variablesState::setVariablesLocalFromDocument;
            }
        }
        return this.variablesState::setVariablesFromDocument;
    }

    @FunctionalInterface
    private static interface UpdateOperation {
        public void apply(long var1, long var3, DirectBuffer var5);
    }
}

