/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbContext;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbLong;
import io.zeebe.db.impl.DbString;
import io.zeebe.engine.state.ZbColumnFamilies;

public class NextValueManager {
    private static final int INITIAL_VALUE = 0;
    private final long initialValue;
    private final ColumnFamily<DbString, DbLong> nextValueColumnFamily;
    private final DbString nextValueKey;
    private final DbLong nextValue;

    public NextValueManager(ZeebeDb<ZbColumnFamilies> zeebeDb, DbContext dbContext, ZbColumnFamilies columnFamily) {
        this(0L, zeebeDb, dbContext, columnFamily);
    }

    public NextValueManager(long initialValue, ZeebeDb<ZbColumnFamilies> zeebeDb, DbContext dbContext, ZbColumnFamilies columnFamily) {
        this.initialValue = initialValue;
        this.nextValueKey = new DbString();
        this.nextValue = new DbLong();
        this.nextValueColumnFamily = zeebeDb.createColumnFamily((Enum)columnFamily, dbContext, (DbKey)this.nextValueKey, (DbValue)this.nextValue);
    }

    public long getNextValue(String key) {
        this.nextValueKey.wrapString(key);
        DbLong zbLong = (DbLong)this.nextValueColumnFamily.get((DbKey)this.nextValueKey);
        long previousKey = this.initialValue;
        if (zbLong != null) {
            previousKey = zbLong.getValue();
        }
        long nextKey = previousKey + 1L;
        this.nextValue.wrapLong(nextKey);
        this.nextValueColumnFamily.put((DbKey)this.nextValueKey, (DbValue)this.nextValue);
        return nextKey;
    }
}

