/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state;

import io.zeebe.logstreams.state.StateStorage;
import java.io.File;

public class StateStorageFactory {
    public static final String DEFAULT_RUNTIME_PATH = "runtime";
    public static final String DEFAULT_SNAPSHOTS_PATH = "snapshots";
    private final File rootDirectory;

    public StateStorageFactory(File rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public StateStorage create(int processorId, String processorName) {
        return this.create(processorId, processorName, null);
    }

    public StateStorage create(int processorId, String processorName, String tmpSuffix) {
        String name = String.format("%d_%s", processorId, processorName);
        File processorDirectory = new File(this.rootDirectory, name);
        File runtimeDirectory = new File(processorDirectory, DEFAULT_RUNTIME_PATH);
        File snapshotsDirectory = new File(processorDirectory, DEFAULT_SNAPSHOTS_PATH);
        if (!processorDirectory.exists()) {
            processorDirectory.mkdir();
        }
        if (!snapshotsDirectory.exists()) {
            snapshotsDirectory.mkdir();
        }
        if (tmpSuffix != null) {
            return new StateStorage(runtimeDirectory, snapshotsDirectory, tmpSuffix);
        }
        return new StateStorage(runtimeDirectory, snapshotsDirectory);
    }
}

