/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbContext;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbLong;
import io.zeebe.db.impl.DbString;
import io.zeebe.engine.Loggers;
import io.zeebe.engine.processor.KeyGenerator;
import io.zeebe.engine.processor.TypedRecord;
import io.zeebe.engine.state.BlackList;
import io.zeebe.engine.state.KeyState;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.deployment.DeploymentsState;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.engine.state.instance.IncidentState;
import io.zeebe.engine.state.instance.JobState;
import io.zeebe.engine.state.message.MessageStartEventSubscriptionState;
import io.zeebe.engine.state.message.MessageState;
import io.zeebe.engine.state.message.MessageSubscriptionState;
import io.zeebe.engine.state.message.WorkflowInstanceSubscriptionState;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.WorkflowInstanceRelated;
import io.zeebe.protocol.record.intent.WorkflowInstanceRelatedIntent;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class ZeebeState {
    private static final String LAST_PROCESSED_EVENT_KEY = "LAST_PROCESSED_EVENT_KEY";
    private static final String BLACKLIST_INSTANCE_MESSAGE = "Blacklist workflow instance {}, due to previous errors.";
    private static final Logger LOG = Loggers.STREAM_PROCESSING;
    private static final long NO_EVENTS_PROCESSED = -1L;
    private final KeyState keyState;
    private final WorkflowState workflowState;
    private final DeploymentsState deploymentState;
    private final JobState jobState;
    private final MessageState messageState;
    private final MessageSubscriptionState messageSubscriptionState;
    private final MessageStartEventSubscriptionState messageStartEventSubscriptionState;
    private final WorkflowInstanceSubscriptionState workflowInstanceSubscriptionState;
    private final IncidentState incidentState;
    private final BlackList blackList;
    private final DbString lastProcessedEventKey;
    private final DbLong lastProcessedEventPosition;
    private final ColumnFamily<DbString, DbLong> lastProcessedRecordPositionColumnFamily;

    public ZeebeState(ZeebeDb<ZbColumnFamilies> zeebeDb, DbContext dbContext) {
        this(1, zeebeDb, dbContext);
    }

    public ZeebeState(int partitionId, ZeebeDb<ZbColumnFamilies> zeebeDb, DbContext dbContext) {
        this.keyState = new KeyState(partitionId, zeebeDb, dbContext);
        this.workflowState = new WorkflowState(zeebeDb, dbContext, this.keyState);
        this.deploymentState = new DeploymentsState(zeebeDb, dbContext);
        this.jobState = new JobState(zeebeDb, dbContext);
        this.messageState = new MessageState(zeebeDb, dbContext);
        this.messageSubscriptionState = new MessageSubscriptionState(zeebeDb, dbContext);
        this.messageStartEventSubscriptionState = new MessageStartEventSubscriptionState(zeebeDb, dbContext);
        this.workflowInstanceSubscriptionState = new WorkflowInstanceSubscriptionState(zeebeDb, dbContext);
        this.incidentState = new IncidentState(zeebeDb, dbContext);
        this.blackList = new BlackList(zeebeDb, dbContext);
        this.lastProcessedEventKey = new DbString();
        this.lastProcessedEventKey.wrapString(LAST_PROCESSED_EVENT_KEY);
        this.lastProcessedEventPosition = new DbLong();
        this.lastProcessedRecordPositionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DEFAULT, dbContext, (DbKey)this.lastProcessedEventKey, (DbValue)this.lastProcessedEventPosition);
    }

    public DeploymentsState getDeploymentState() {
        return this.deploymentState;
    }

    public WorkflowState getWorkflowState() {
        return this.workflowState;
    }

    public JobState getJobState() {
        return this.jobState;
    }

    public MessageState getMessageState() {
        return this.messageState;
    }

    public MessageSubscriptionState getMessageSubscriptionState() {
        return this.messageSubscriptionState;
    }

    public MessageStartEventSubscriptionState getMessageStartEventSubscriptionState() {
        return this.messageStartEventSubscriptionState;
    }

    public WorkflowInstanceSubscriptionState getWorkflowInstanceSubscriptionState() {
        return this.workflowInstanceSubscriptionState;
    }

    public IncidentState getIncidentState() {
        return this.incidentState;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyState;
    }

    public boolean isOnBlacklist(TypedRecord record) {
        long workflowInstanceKey;
        Object value = record.getValue();
        if (value instanceof WorkflowInstanceRelated && (workflowInstanceKey = ((WorkflowInstanceRelated)value).getWorkflowInstanceKey()) >= 0L) {
            return this.blackList.isOnBlacklist(workflowInstanceKey);
        }
        return false;
    }

    public boolean tryToBlacklist(TypedRecord<?> typedRecord, Consumer<Long> onBlacklistingInstance) {
        Object value;
        Intent intent = typedRecord.getMetadata().getIntent();
        if (this.shouldBeBlacklisted(intent) && (value = typedRecord.getValue()) instanceof WorkflowInstanceRelated) {
            long workflowInstanceKey = ((WorkflowInstanceRelated)value).getWorkflowInstanceKey();
            this.blacklist(workflowInstanceKey);
            onBlacklistingInstance.accept(workflowInstanceKey);
        }
        return false;
    }

    private boolean shouldBeBlacklisted(Intent intent) {
        if (intent instanceof WorkflowInstanceRelatedIntent) {
            WorkflowInstanceRelatedIntent workflowInstanceRelatedIntent = (WorkflowInstanceRelatedIntent)intent;
            return workflowInstanceRelatedIntent.shouldBlacklistInstanceOnError();
        }
        return false;
    }

    private void blacklist(long workflowInstanceKey) {
        if (workflowInstanceKey >= 0L) {
            LOG.warn(BLACKLIST_INSTANCE_MESSAGE, (Object)workflowInstanceKey);
            this.blackList.blacklist(workflowInstanceKey);
        }
    }

    public void markAsProcessed(long position) {
        this.lastProcessedEventPosition.wrapLong(position);
        this.lastProcessedRecordPositionColumnFamily.put((DbKey)this.lastProcessedEventKey, (DbValue)this.lastProcessedEventPosition);
    }

    public long getLastSuccessfulProcessedRecordPosition() {
        DbLong position = (DbLong)this.lastProcessedRecordPositionColumnFamily.get((DbKey)this.lastProcessedEventKey);
        return position != null ? position.getValue() : -1L;
    }
}

