/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.deployment;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbContext;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbLong;
import io.zeebe.engine.processor.workflow.deployment.distribute.PendingDeploymentDistribution;
import io.zeebe.engine.state.ZbColumnFamilies;
import java.util.function.ObjLongConsumer;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class DeploymentsState {
    private final PendingDeploymentDistribution pendingDeploymentDistribution;
    private final DbLong deploymentKey = new DbLong();
    private final ColumnFamily<DbLong, PendingDeploymentDistribution> pendingDeploymentColumnFamily;

    public DeploymentsState(ZeebeDb<ZbColumnFamilies> zeebeDb, DbContext dbContext) {
        this.pendingDeploymentDistribution = new PendingDeploymentDistribution((DirectBuffer)new UnsafeBuffer(0L, 0), -1L);
        this.pendingDeploymentColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PENDING_DEPLOYMENT, dbContext, (DbKey)this.deploymentKey, (DbValue)this.pendingDeploymentDistribution);
    }

    public void putPendingDeployment(long key, PendingDeploymentDistribution pendingDeploymentDistribution) {
        this.deploymentKey.wrapLong(key);
        this.pendingDeploymentColumnFamily.put((DbKey)this.deploymentKey, (DbValue)pendingDeploymentDistribution);
    }

    private PendingDeploymentDistribution getPending(long key) {
        this.deploymentKey.wrapLong(key);
        return (PendingDeploymentDistribution)this.pendingDeploymentColumnFamily.get((DbKey)this.deploymentKey);
    }

    public PendingDeploymentDistribution getPendingDeployment(long key) {
        return this.getPending(key);
    }

    public PendingDeploymentDistribution removePendingDeployment(long key) {
        PendingDeploymentDistribution pending = this.getPending(key);
        if (pending != null) {
            this.pendingDeploymentColumnFamily.delete((DbKey)this.deploymentKey);
        }
        return pending;
    }

    public void foreachPending(ObjLongConsumer<PendingDeploymentDistribution> consumer) {
        this.pendingDeploymentColumnFamily.forEach((deploymentKey, pendingDeployment) -> consumer.accept((PendingDeploymentDistribution)pendingDeployment, deploymentKey.getValue()));
    }
}

