/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.deployment;

import io.zeebe.db.DbValue;
import io.zeebe.db.impl.ZeebeDbConstants;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.zeebe.protocol.impl.record.value.deployment.Workflow;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class PersistedWorkflow
implements DbValue {
    int version = -1;
    long key = -1L;
    final UnsafeBuffer bpmnProcessId = new UnsafeBuffer(0L, 0);
    final UnsafeBuffer resourceName = new UnsafeBuffer(0L, 0);
    final UnsafeBuffer resource = new UnsafeBuffer(0L, 0);

    public void wrap(DeploymentResource resource, Workflow workflow, long workflowKey) {
        this.resource.wrap(resource.getResourceBuffer());
        this.resourceName.wrap(resource.getResourceNameBuffer());
        this.bpmnProcessId.wrap(workflow.getBpmnProcessIdBuffer());
        this.version = workflow.getVersion();
        this.key = workflowKey;
    }

    public int getVersion() {
        return this.version;
    }

    public long getKey() {
        return this.key;
    }

    public UnsafeBuffer getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public UnsafeBuffer getResourceName() {
        return this.resourceName;
    }

    public UnsafeBuffer getResource() {
        return this.resource;
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        int valueOffset = offset;
        this.version = buffer.getInt(offset, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.key = buffer.getLong(valueOffset += 4, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        valueOffset += 8;
        valueOffset = BufferUtil.readIntoBuffer((DirectBuffer)buffer, (int)valueOffset, (DirectBuffer)this.bpmnProcessId);
        valueOffset = BufferUtil.readIntoBuffer((DirectBuffer)buffer, (int)valueOffset, (DirectBuffer)this.resourceName);
        BufferUtil.readIntoBuffer((DirectBuffer)buffer, (int)valueOffset, (DirectBuffer)this.resource);
    }

    public int getLength() {
        return 24 + this.bpmnProcessId.capacity() + this.resourceName.capacity() + this.resource.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        int valueOffset = offset;
        buffer.putInt(offset, this.version, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putLong(valueOffset += 4, this.key, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        valueOffset += 8;
        valueOffset = BufferUtil.writeIntoBuffer((MutableDirectBuffer)buffer, (int)valueOffset, (DirectBuffer)this.bpmnProcessId);
        valueOffset = BufferUtil.writeIntoBuffer((MutableDirectBuffer)buffer, (int)valueOffset, (DirectBuffer)this.resourceName);
        valueOffset = BufferUtil.writeIntoBuffer((MutableDirectBuffer)buffer, (int)valueOffset, (DirectBuffer)this.resource);
        assert (valueOffset - offset == this.getLength()) : "End offset differs with getLength()";
    }

    public String toString() {
        return "PersistedWorkflow{version=" + this.version + ", key=" + this.key + ", bpmnProcessId=" + BufferUtil.bufferAsString((DirectBuffer)this.bpmnProcessId) + ", resourceName=" + BufferUtil.bufferAsString((DirectBuffer)this.resourceName) + ", resource=" + BufferUtil.bufferAsString((DirectBuffer)this.resource) + '}';
    }
}

