/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.deployment;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbContext;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbCompositeKey;
import io.zeebe.db.impl.DbLong;
import io.zeebe.db.impl.DbString;
import io.zeebe.engine.processor.workflow.deployment.model.element.ExecutableWorkflow;
import io.zeebe.engine.processor.workflow.deployment.model.transformation.BpmnTransformer;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.deployment.DeployedWorkflow;
import io.zeebe.engine.state.deployment.PersistedWorkflow;
import io.zeebe.model.bpmn.Bpmn;
import io.zeebe.model.bpmn.BpmnModelInstance;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.zeebe.protocol.impl.record.value.deployment.Workflow;
import io.zeebe.util.buffer.BufferUtil;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Long2ObjectHashMap;
import org.agrona.collections.LongHashSet;
import org.agrona.io.DirectBufferInputStream;

public class WorkflowPersistenceCache {
    private final BpmnTransformer transformer = new BpmnTransformer();
    private final Map<DirectBuffer, Long2ObjectHashMap<DeployedWorkflow>> workflowsByProcessIdAndVersion = new HashMap<DirectBuffer, Long2ObjectHashMap<DeployedWorkflow>>();
    private final LongHashSet deployments;
    private final Long2ObjectHashMap<DeployedWorkflow> workflowsByKey;
    private final ColumnFamily<DbLong, PersistedWorkflow> workflowColumnFamily;
    private final DbLong workflowKey;
    private final PersistedWorkflow persistedWorkflow;
    private final ColumnFamily<DbCompositeKey, PersistedWorkflow> workflowByIdAndVersionColumnFamily;
    private final DbCompositeKey<DbString, DbLong> idAndVersionKey;
    private final ColumnFamily<DbString, DbLong> latestWorkflowColumnFamily;
    private final DbString workflowId;
    private final DbLong workflowVersion;
    private final ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();

    public WorkflowPersistenceCache(ZeebeDb<ZbColumnFamilies> zeebeDb, DbContext dbContext) {
        this.workflowKey = new DbLong();
        this.persistedWorkflow = new PersistedWorkflow();
        this.workflowColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.WORKFLOW_CACHE, dbContext, (DbKey)this.workflowKey, (DbValue)this.persistedWorkflow);
        this.workflowId = new DbString();
        this.workflowVersion = new DbLong();
        this.idAndVersionKey = new DbCompositeKey((DbKey)this.workflowId, (DbKey)this.workflowVersion);
        this.workflowByIdAndVersionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.WORKFLOW_CACHE_BY_ID_AND_VERSION, dbContext, this.idAndVersionKey, (DbValue)this.persistedWorkflow);
        this.latestWorkflowColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.WORKFLOW_CACHE_LATEST_KEY, dbContext, (DbKey)this.workflowId, (DbValue)this.workflowVersion);
        this.deployments = new LongHashSet();
        this.workflowsByKey = new Long2ObjectHashMap();
    }

    protected boolean putDeployment(long deploymentKey, DeploymentRecord deploymentRecord) {
        boolean isNewDeployment;
        boolean bl = isNewDeployment = !this.deployments.contains(deploymentKey);
        if (isNewDeployment) {
            for (Workflow workflow : deploymentRecord.workflows()) {
                long workflowKey = workflow.getKey();
                DirectBuffer resourceName = workflow.getResourceNameBuffer();
                for (DeploymentResource resource : deploymentRecord.resources()) {
                    if (!resource.getResourceNameBuffer().equals(resourceName)) continue;
                    this.persistWorkflow(workflowKey, workflow, resource);
                    this.updateLatestVersion(workflow);
                }
            }
            this.deployments.add(deploymentKey);
        }
        return isNewDeployment;
    }

    private void persistWorkflow(long workflowKey, Workflow workflow, DeploymentResource resource) {
        this.persistedWorkflow.wrap(resource, workflow, workflowKey);
        this.workflowKey.wrapLong(workflowKey);
        this.workflowColumnFamily.put((DbKey)this.workflowKey, (DbValue)this.persistedWorkflow);
        this.workflowId.wrapBuffer(workflow.getBpmnProcessIdBuffer());
        this.workflowVersion.wrapLong((long)workflow.getVersion());
        this.workflowByIdAndVersionColumnFamily.put(this.idAndVersionKey, (DbValue)this.persistedWorkflow);
    }

    private void updateLatestVersion(Workflow workflow) {
        long latestVersion;
        this.workflowId.wrapBuffer(workflow.getBpmnProcessIdBuffer());
        DbLong storedVersion = (DbLong)this.latestWorkflowColumnFamily.get((DbKey)this.workflowId);
        long l = latestVersion = storedVersion == null ? -1L : storedVersion.getValue();
        if ((long)workflow.getVersion() > latestVersion) {
            this.workflowVersion.wrapLong((long)workflow.getVersion());
            this.latestWorkflowColumnFamily.put((DbKey)this.workflowId, (DbValue)this.workflowVersion);
        }
    }

    private DeployedWorkflow updateInMemoryState(PersistedWorkflow persistedWorkflow) {
        persistedWorkflow.write((MutableDirectBuffer)this.buffer, 0);
        PersistedWorkflow copiedWorkflow = new PersistedWorkflow();
        copiedWorkflow.wrap((DirectBuffer)this.buffer, 0, persistedWorkflow.getLength());
        BpmnModelInstance modelInstance = this.readModelInstanceFromBuffer((DirectBuffer)copiedWorkflow.getResource());
        List<ExecutableWorkflow> definitions = this.transformer.transformDefinitions(modelInstance);
        ExecutableWorkflow executableWorkflow = definitions.stream().filter(w -> BufferUtil.equals((DirectBuffer)persistedWorkflow.getBpmnProcessId(), (DirectBuffer)w.getId())).findFirst().get();
        DeployedWorkflow deployedWorkflow = new DeployedWorkflow(executableWorkflow, copiedWorkflow);
        this.addWorkflowToInMemoryState(deployedWorkflow);
        return deployedWorkflow;
    }

    private BpmnModelInstance readModelInstanceFromBuffer(DirectBuffer buffer) {
        try (DirectBufferInputStream stream = new DirectBufferInputStream(buffer);){
            BpmnModelInstance bpmnModelInstance = Bpmn.readModelFromStream((InputStream)stream);
            return bpmnModelInstance;
        }
    }

    private void addWorkflowToInMemoryState(DeployedWorkflow deployedWorkflow) {
        DirectBuffer bpmnProcessId = deployedWorkflow.getBpmnProcessId();
        this.workflowsByKey.put(deployedWorkflow.getKey(), (Object)deployedWorkflow);
        Long2ObjectHashMap versionMap = this.workflowsByProcessIdAndVersion.get(bpmnProcessId);
        if (versionMap == null) {
            versionMap = new Long2ObjectHashMap();
            this.workflowsByProcessIdAndVersion.put(bpmnProcessId, (Long2ObjectHashMap<DeployedWorkflow>)versionMap);
        }
        int version = deployedWorkflow.getVersion();
        versionMap.put((long)version, (Object)deployedWorkflow);
    }

    public DeployedWorkflow getLatestWorkflowVersionByProcessId(DirectBuffer processId) {
        DeployedWorkflow deployedWorkflow;
        Long2ObjectHashMap<DeployedWorkflow> versionMap = this.workflowsByProcessIdAndVersion.get(processId);
        this.workflowId.wrapBuffer(processId);
        DbLong latestVersion = (DbLong)this.latestWorkflowColumnFamily.get((DbKey)this.workflowId);
        if (versionMap == null) {
            deployedWorkflow = this.lookupWorkflowByIdAndPersistedVersion(latestVersion);
        } else {
            deployedWorkflow = (DeployedWorkflow)versionMap.get(latestVersion.getValue());
            if (deployedWorkflow == null) {
                deployedWorkflow = this.lookupWorkflowByIdAndPersistedVersion(latestVersion);
            }
        }
        return deployedWorkflow;
    }

    private DeployedWorkflow lookupWorkflowByIdAndPersistedVersion(DbLong version) {
        long latestVersion = version != null ? version.getValue() : -1L;
        this.workflowVersion.wrapLong(latestVersion);
        PersistedWorkflow persistedWorkflow = (PersistedWorkflow)this.workflowByIdAndVersionColumnFamily.get(this.idAndVersionKey);
        if (persistedWorkflow != null) {
            DeployedWorkflow deployedWorkflow = this.updateInMemoryState(persistedWorkflow);
            return deployedWorkflow;
        }
        return null;
    }

    public DeployedWorkflow getWorkflowByProcessIdAndVersion(DirectBuffer processId, int version) {
        Long2ObjectHashMap<DeployedWorkflow> versionMap = this.workflowsByProcessIdAndVersion.get(processId);
        if (versionMap != null) {
            DeployedWorkflow deployedWorkflow = (DeployedWorkflow)versionMap.get((long)version);
            return deployedWorkflow != null ? deployedWorkflow : this.lookupPersistenceState(processId, version);
        }
        return this.lookupPersistenceState(processId, version);
    }

    private DeployedWorkflow lookupPersistenceState(DirectBuffer processId, int version) {
        this.workflowId.wrapBuffer(processId);
        this.workflowVersion.wrapLong((long)version);
        PersistedWorkflow persistedWorkflow = (PersistedWorkflow)this.workflowByIdAndVersionColumnFamily.get(this.idAndVersionKey);
        if (persistedWorkflow != null) {
            this.updateInMemoryState(persistedWorkflow);
            Long2ObjectHashMap<DeployedWorkflow> newVersionMap = this.workflowsByProcessIdAndVersion.get(processId);
            if (newVersionMap != null) {
                return (DeployedWorkflow)newVersionMap.get((long)version);
            }
        }
        return null;
    }

    public DeployedWorkflow getWorkflowByKey(long key) {
        DeployedWorkflow deployedWorkflow = (DeployedWorkflow)this.workflowsByKey.get(key);
        if (deployedWorkflow != null) {
            return deployedWorkflow;
        }
        return this.lookupPersistenceStateForWorkflowByKey(key);
    }

    private DeployedWorkflow lookupPersistenceStateForWorkflowByKey(long workflowKey) {
        this.workflowKey.wrapLong(workflowKey);
        PersistedWorkflow persistedWorkflow = (PersistedWorkflow)this.workflowColumnFamily.get((DbKey)this.workflowKey);
        if (persistedWorkflow != null) {
            this.updateInMemoryState(persistedWorkflow);
            DeployedWorkflow deployedWorkflow = (DeployedWorkflow)this.workflowsByKey.get(workflowKey);
            return deployedWorkflow;
        }
        return null;
    }

    public Collection<DeployedWorkflow> getWorkflows() {
        this.updateCompleteInMemoryState();
        return this.workflowsByKey.values();
    }

    public Collection<DeployedWorkflow> getWorkflowsByBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.updateCompleteInMemoryState();
        Long2ObjectHashMap<DeployedWorkflow> workflowsByVersions = this.workflowsByProcessIdAndVersion.get(bpmnProcessId);
        if (workflowsByVersions != null) {
            return workflowsByVersions.values();
        }
        return Collections.emptyList();
    }

    private void updateCompleteInMemoryState() {
        this.workflowColumnFamily.forEach(workflow -> this.updateInMemoryState(this.persistedWorkflow));
    }
}

