/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.deployment;

import io.zeebe.db.DbContext;
import io.zeebe.db.ZeebeDb;
import io.zeebe.engine.processor.KeyGenerator;
import io.zeebe.engine.state.NextValueManager;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.deployment.DeployedWorkflow;
import io.zeebe.engine.state.deployment.WorkflowPersistenceCache;
import io.zeebe.engine.state.instance.ElementInstanceState;
import io.zeebe.engine.state.instance.EventScopeInstanceState;
import io.zeebe.engine.state.instance.TimerInstanceState;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import java.util.Collection;
import org.agrona.DirectBuffer;

public class WorkflowState {
    private final NextValueManager versionManager;
    private final WorkflowPersistenceCache workflowPersistenceCache;
    private final TimerInstanceState timerInstanceState;
    private final ElementInstanceState elementInstanceState;
    private final EventScopeInstanceState eventScopeInstanceState;

    public WorkflowState(ZeebeDb<ZbColumnFamilies> zeebeDb, DbContext dbContext, KeyGenerator keyGenerator) {
        this.versionManager = new NextValueManager(zeebeDb, dbContext, ZbColumnFamilies.WORKFLOW_VERSION);
        this.workflowPersistenceCache = new WorkflowPersistenceCache(zeebeDb, dbContext);
        this.timerInstanceState = new TimerInstanceState(zeebeDb, dbContext);
        this.elementInstanceState = new ElementInstanceState(zeebeDb, dbContext, keyGenerator);
        this.eventScopeInstanceState = new EventScopeInstanceState(zeebeDb, dbContext);
    }

    public int getNextWorkflowVersion(String bpmnProcessId) {
        return (int)this.versionManager.getNextValue(bpmnProcessId);
    }

    public boolean putDeployment(long deploymentKey, DeploymentRecord deploymentRecord) {
        return this.workflowPersistenceCache.putDeployment(deploymentKey, deploymentRecord);
    }

    public DeployedWorkflow getWorkflowByProcessIdAndVersion(DirectBuffer bpmnProcessId, int version) {
        return this.workflowPersistenceCache.getWorkflowByProcessIdAndVersion(bpmnProcessId, version);
    }

    public DeployedWorkflow getWorkflowByKey(long workflowKey) {
        return this.workflowPersistenceCache.getWorkflowByKey(workflowKey);
    }

    public DeployedWorkflow getLatestWorkflowVersionByProcessId(DirectBuffer bpmnProcessId) {
        return this.workflowPersistenceCache.getLatestWorkflowVersionByProcessId(bpmnProcessId);
    }

    public Collection<DeployedWorkflow> getWorkflows() {
        return this.workflowPersistenceCache.getWorkflows();
    }

    public Collection<DeployedWorkflow> getWorkflowsByBpmnProcessId(DirectBuffer processId) {
        return this.workflowPersistenceCache.getWorkflowsByBpmnProcessId(processId);
    }

    public TimerInstanceState getTimerState() {
        return this.timerInstanceState;
    }

    public ElementInstanceState getElementInstanceState() {
        return this.elementInstanceState;
    }

    public EventScopeInstanceState getEventScopeInstanceState() {
        return this.eventScopeInstanceState;
    }
}

